# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class GoalsResponse(BaseModel):
    """
    GoalsResponse
    """
    account_guid: Optional[StrictStr] = Field(None, description="Unique identifier of the account for the goal.")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Amount of the goal.")
    current_amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The current amount of the goal.")
    guid: Optional[StrictStr] = Field(None, description="The unique identifier for the goal. Defined by MX.")
    goal_type_name: Optional[StrictStr] = Field(None, description="The goal type.")
    meta_type_name: Optional[StrictStr] = Field(None, description="The category of the goal.")
    name: Optional[StrictStr] = Field(None, description="The name of the goal.")
    completed_at: Optional[StrictStr] = Field(None, description="Date and time the goal was completed.")
    has_been_spent: Optional[StrictBool] = Field(None, description="Determines if the goal has been spent.")
    is_complete: Optional[StrictBool] = Field(None, description="Determines if the goal is complete.")
    metadata: Optional[StrictStr] = Field(None, description="Additional information a partner can store on the goal.")
    position: Optional[StrictInt] = Field(None, description="The priority of the goal in relation to multiple goals.")
    projected_to_complete_at: Optional[StrictStr] = Field(None, description="The date on which the project was completed.")
    targeted_to_complete_at: Optional[StrictStr] = None
    track_type_name: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = Field(None, description="The unique identifier for the the user. Defined by MX.")
    __properties = ["account_guid", "amount", "current_amount", "guid", "goal_type_name", "meta_type_name", "name", "completed_at", "has_been_spent", "is_complete", "metadata", "position", "projected_to_complete_at", "targeted_to_complete_at", "track_type_name", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GoalsResponse:
        """Create an instance of GoalsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GoalsResponse:
        """Create an instance of GoalsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GoalsResponse.parse_obj(obj)

        _obj = GoalsResponse.parse_obj({
            "account_guid": obj.get("account_guid"),
            "amount": obj.get("amount"),
            "current_amount": obj.get("current_amount"),
            "guid": obj.get("guid"),
            "goal_type_name": obj.get("goal_type_name"),
            "meta_type_name": obj.get("meta_type_name"),
            "name": obj.get("name"),
            "completed_at": obj.get("completed_at"),
            "has_been_spent": obj.get("has_been_spent"),
            "is_complete": obj.get("is_complete"),
            "metadata": obj.get("metadata"),
            "position": obj.get("position"),
            "projected_to_complete_at": obj.get("projected_to_complete_at"),
            "targeted_to_complete_at": obj.get("targeted_to_complete_at"),
            "track_type_name": obj.get("track_type_name"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


