# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, StrictBool, StrictStr

class InsightResponse(BaseModel):
    """
    InsightResponse
    """
    active_at: Optional[StrictStr] = None
    client_guid: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    cta_clicked_at: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    has_associated_accounts: Optional[StrictBool] = None
    has_associated_merchants: Optional[StrictBool] = None
    has_associated_scheduled_payments: Optional[StrictBool] = None
    has_associated_transactions: Optional[StrictBool] = None
    has_been_displayed: Optional[StrictBool] = None
    is_dismissed: Optional[StrictBool] = None
    micro_call_to_action: Optional[StrictStr] = None
    micro_description: Optional[StrictStr] = None
    micro_title: Optional[StrictStr] = None
    template: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    user_id: Optional[Any] = None
    __properties = ["active_at", "client_guid", "created_at", "cta_clicked_at", "description", "guid", "has_associated_accounts", "has_associated_merchants", "has_associated_scheduled_payments", "has_associated_transactions", "has_been_displayed", "is_dismissed", "micro_call_to_action", "micro_description", "micro_title", "template", "title", "updated_at", "user_guid", "user_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InsightResponse:
        """Create an instance of InsightResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if active_at (nullable) is None
        # and __fields_set__ contains the field
        if self.active_at is None and "active_at" in self.__fields_set__:
            _dict['active_at'] = None

        # set to None if client_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.client_guid is None and "client_guid" in self.__fields_set__:
            _dict['client_guid'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if cta_clicked_at (nullable) is None
        # and __fields_set__ contains the field
        if self.cta_clicked_at is None and "cta_clicked_at" in self.__fields_set__:
            _dict['cta_clicked_at'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if has_associated_accounts (nullable) is None
        # and __fields_set__ contains the field
        if self.has_associated_accounts is None and "has_associated_accounts" in self.__fields_set__:
            _dict['has_associated_accounts'] = None

        # set to None if has_associated_merchants (nullable) is None
        # and __fields_set__ contains the field
        if self.has_associated_merchants is None and "has_associated_merchants" in self.__fields_set__:
            _dict['has_associated_merchants'] = None

        # set to None if has_associated_scheduled_payments (nullable) is None
        # and __fields_set__ contains the field
        if self.has_associated_scheduled_payments is None and "has_associated_scheduled_payments" in self.__fields_set__:
            _dict['has_associated_scheduled_payments'] = None

        # set to None if has_associated_transactions (nullable) is None
        # and __fields_set__ contains the field
        if self.has_associated_transactions is None and "has_associated_transactions" in self.__fields_set__:
            _dict['has_associated_transactions'] = None

        # set to None if has_been_displayed (nullable) is None
        # and __fields_set__ contains the field
        if self.has_been_displayed is None and "has_been_displayed" in self.__fields_set__:
            _dict['has_been_displayed'] = None

        # set to None if is_dismissed (nullable) is None
        # and __fields_set__ contains the field
        if self.is_dismissed is None and "is_dismissed" in self.__fields_set__:
            _dict['is_dismissed'] = None

        # set to None if micro_call_to_action (nullable) is None
        # and __fields_set__ contains the field
        if self.micro_call_to_action is None and "micro_call_to_action" in self.__fields_set__:
            _dict['micro_call_to_action'] = None

        # set to None if micro_description (nullable) is None
        # and __fields_set__ contains the field
        if self.micro_description is None and "micro_description" in self.__fields_set__:
            _dict['micro_description'] = None

        # set to None if micro_title (nullable) is None
        # and __fields_set__ contains the field
        if self.micro_title is None and "micro_title" in self.__fields_set__:
            _dict['micro_title'] = None

        # set to None if template (nullable) is None
        # and __fields_set__ contains the field
        if self.template is None and "template" in self.__fields_set__:
            _dict['template'] = None

        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['user_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InsightResponse:
        """Create an instance of InsightResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InsightResponse.parse_obj(obj)

        _obj = InsightResponse.parse_obj({
            "active_at": obj.get("active_at"),
            "client_guid": obj.get("client_guid"),
            "created_at": obj.get("created_at"),
            "cta_clicked_at": obj.get("cta_clicked_at"),
            "description": obj.get("description"),
            "guid": obj.get("guid"),
            "has_associated_accounts": obj.get("has_associated_accounts"),
            "has_associated_merchants": obj.get("has_associated_merchants"),
            "has_associated_scheduled_payments": obj.get("has_associated_scheduled_payments"),
            "has_associated_transactions": obj.get("has_associated_transactions"),
            "has_been_displayed": obj.get("has_been_displayed"),
            "is_dismissed": obj.get("is_dismissed"),
            "micro_call_to_action": obj.get("micro_call_to_action"),
            "micro_description": obj.get("micro_description"),
            "micro_title": obj.get("micro_title"),
            "template": obj.get("template"),
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at"),
            "user_guid": obj.get("user_guid"),
            "user_id": obj.get("user_id")
        })
        return _obj


