# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class BudgetResponse(BaseModel):
    """
    BudgetResponse
    """
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="A goal amount set by the user for a category's transaction total during a month.")
    category_guid: Optional[StrictStr] = Field(None, description="Unique identifier for the budget category. Defined by MX.")
    created_at: Optional[StrictStr] = Field(None, description="Date and time the budget was created, represented in ISO 8601 format with timestamp.")
    guid: Optional[StrictStr] = Field(None, description="Unique identifier for the budget. Defined by MX.")
    is_exceeded: Optional[StrictBool] = Field(None, description="If the budget has been exceeded, this field will be true. Otherwise, this field will be false.")
    is_off_track: Optional[StrictBool] = Field(None, description="If the budget is off track, this field will be true. Otherwise, this field will be false.")
    metadata: Optional[StrictStr] = Field(None, description="Additional information a partner can store on the budget.")
    name: Optional[StrictStr] = Field(None, description="The name of the budget that is visible to the user (ie \"Food\", \"Bills\", \"Entertainment\", etc).")
    off_track_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The percentage amount of off track spending. (Deprecated).")
    parent_guid: Optional[StrictStr] = Field(None, description="Unique identifier for the parent budget. Defined by MX.")
    percent_spent: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The percentage of a budget that has been spent during the current calendar month Calculated as the transaction total divided by the amount and then multiplied by 100.A value of zero will be returned when `amount` is zero.")
    projected_spending: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The projected amount of spending for the budget.")
    revision: Optional[StrictInt] = Field(None, description="The revision number of this budget record.")
    transaction_total: Optional[Any] = Field(None, description="The cumulative amount of all transactions under the budget.")
    updated_at: Optional[Any] = Field(None, description="Date and time the budget was updated, represented in ISO 8601 format with timestamp.")
    user_guid: Optional[Any] = Field(None, description="Unique identifier for the user. Defined by MX.")
    __properties = ["amount", "category_guid", "created_at", "guid", "is_exceeded", "is_off_track", "metadata", "name", "off_track_percentage", "parent_guid", "percent_spent", "projected_spending", "revision", "transaction_total", "updated_at", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BudgetResponse:
        """Create an instance of BudgetResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if metadata (nullable) is None
        # and __fields_set__ contains the field
        if self.metadata is None and "metadata" in self.__fields_set__:
            _dict['metadata'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if off_track_percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.off_track_percentage is None and "off_track_percentage" in self.__fields_set__:
            _dict['off_track_percentage'] = None

        # set to None if parent_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_guid is None and "parent_guid" in self.__fields_set__:
            _dict['parent_guid'] = None

        # set to None if percent_spent (nullable) is None
        # and __fields_set__ contains the field
        if self.percent_spent is None and "percent_spent" in self.__fields_set__:
            _dict['percent_spent'] = None

        # set to None if transaction_total (nullable) is None
        # and __fields_set__ contains the field
        if self.transaction_total is None and "transaction_total" in self.__fields_set__:
            _dict['transaction_total'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BudgetResponse:
        """Create an instance of BudgetResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BudgetResponse.parse_obj(obj)

        _obj = BudgetResponse.parse_obj({
            "amount": obj.get("amount"),
            "category_guid": obj.get("category_guid"),
            "created_at": obj.get("created_at"),
            "guid": obj.get("guid"),
            "is_exceeded": obj.get("is_exceeded"),
            "is_off_track": obj.get("is_off_track"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "off_track_percentage": obj.get("off_track_percentage"),
            "parent_guid": obj.get("parent_guid"),
            "percent_spent": obj.get("percent_spent"),
            "projected_spending": obj.get("projected_spending"),
            "revision": obj.get("revision"),
            "transaction_total": obj.get("transaction_total"),
            "updated_at": obj.get("updated_at"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


