# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from mx_platform_python.models.tag_create_request_body import TagCreateRequestBody
from mx_platform_python.models.tag_response_body import TagResponseBody
from mx_platform_python.models.tag_update_request_body import TagUpdateRequestBody
from mx_platform_python.models.tags_response_body import TagsResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TagsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_tag(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_create_request_body : Annotated[TagCreateRequestBody, Field(..., description="Tag object to be created with required parameters (tag_guid)")], **kwargs) -> TagResponseBody:  # noqa: E501
        """Create tag  # noqa: E501

        Use this endpoint to create a new custom tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tag(user_guid, tag_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_create_request_body: Tag object to be created with required parameters (tag_guid) (required)
        :type tag_create_request_body: TagCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TagResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_tag_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_tag_with_http_info(user_guid, tag_create_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_tag_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_create_request_body : Annotated[TagCreateRequestBody, Field(..., description="Tag object to be created with required parameters (tag_guid)")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create tag  # noqa: E501

        Use this endpoint to create a new custom tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tag_with_http_info(user_guid, tag_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_create_request_body: Tag object to be created with required parameters (tag_guid) (required)
        :type tag_create_request_body: TagCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TagResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'tag_create_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tag" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['tag_create_request_body'] is not None:
            _body_params = _params['tag_create_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TagResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/tags', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_tag(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], accept : Annotated[StrictStr, Field(..., description="Specifies the media type expected in the response.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> None:  # noqa: E501
        """Delete tag  # noqa: E501

        Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tag(tag_guid, accept, user_guid, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param accept: Specifies the media type expected in the response. (required)
        :type accept: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_tag_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_tag_with_http_info(tag_guid, accept, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_tag_with_http_info(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], accept : Annotated[StrictStr, Field(..., description="Specifies the media type expected in the response.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete tag  # noqa: E501

        Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tag_with_http_info(tag_guid, accept, user_guid, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param accept: Specifies the media type expected in the response. (required)
        :type accept: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'tag_guid',
            'accept',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['tag_guid']:
            _path_params['tag_guid'] = _params['tag_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['accept']:
            _header_params['Accept'] = _params['accept']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/tags/{tag_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_tags(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> TagsResponseBody:  # noqa: E501
        """List tags  # noqa: E501

        Use this endpoint to list all tags associated with the specified `user`. Each user includes the `Business` tag by default.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_tags(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TagsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_tags_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_tags_with_http_info(user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_tags_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List tags  # noqa: E501

        Use this endpoint to list all tags associated with the specified `user`. Each user includes the `Business` tag by default.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_tags_with_http_info(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TagsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tags" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TagsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/tags', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_tag(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> TagResponseBody:  # noqa: E501
        """Read tag  # noqa: E501

        Use this endpoint to read the attributes of a particular tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_tag(tag_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TagResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_tag_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_tag_with_http_info(tag_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def read_tag_with_http_info(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read tag  # noqa: E501

        Use this endpoint to read the attributes of a particular tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_tag_with_http_info(tag_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TagResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'tag_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tag" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['tag_guid']:
            _path_params['tag_guid'] = _params['tag_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TagResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/tags/{tag_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_tag(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_update_request_body : Annotated[TagUpdateRequestBody, Field(..., description="Tag object to be updated with required parameter (tag_guid)")], **kwargs) -> TagResponseBody:  # noqa: E501
        """Update tag  # noqa: E501

        Use this endpoint to update the name of a specific tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tag(tag_guid, user_guid, tag_update_request_body, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_update_request_body: Tag object to be updated with required parameter (tag_guid) (required)
        :type tag_update_request_body: TagUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TagResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_tag_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_tag_with_http_info(tag_guid, user_guid, tag_update_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_tag_with_http_info(self, tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_update_request_body : Annotated[TagUpdateRequestBody, Field(..., description="Tag object to be updated with required parameter (tag_guid)")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update tag  # noqa: E501

        Use this endpoint to update the name of a specific tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tag_with_http_info(tag_guid, user_guid, tag_update_request_body, async_req=True)
        >>> result = thread.get()

        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_update_request_body: Tag object to be updated with required parameter (tag_guid) (required)
        :type tag_update_request_body: TagUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TagResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'tag_guid',
            'user_guid',
            'tag_update_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tag" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['tag_guid']:
            _path_params['tag_guid'] = _params['tag_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['tag_update_request_body'] is not None:
            _body_params = _params['tag_update_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TagResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/tags/{tag_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
