# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt

class MonthlyCashFlowProfileRequest(BaseModel):
    """
    MonthlyCashFlowProfileRequest
    """
    goals_contribution: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The monthly dollar amount allocated for goals.")
    uses_estimated_goals_contribution: Optional[StrictBool] = Field(None, description="Determines if the user uses estimated goals contribution.")
    __properties = ["goals_contribution", "uses_estimated_goals_contribution"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MonthlyCashFlowProfileRequest:
        """Create an instance of MonthlyCashFlowProfileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MonthlyCashFlowProfileRequest:
        """Create an instance of MonthlyCashFlowProfileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MonthlyCashFlowProfileRequest.parse_obj(obj)

        _obj = MonthlyCashFlowProfileRequest.parse_obj({
            "goals_contribution": obj.get("goals_contribution"),
            "uses_estimated_goals_contribution": obj.get("uses_estimated_goals_contribution")
        })
        return _obj


