# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr, conlist

class SpendingPlanIterationItemResponse(BaseModel):
    """
    SpendingPlanIterationItemResponse
    """
    actual_amount: Optional[Union[StrictFloat, StrictInt]] = None
    category_guid: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    item_type: Optional[StrictStr] = None
    planned_amount: Optional[Union[StrictFloat, StrictInt]] = None
    scheduled_payment_guid: Optional[StrictStr] = None
    spending_plan_iteration_guid: Optional[StrictStr] = None
    top_level_category_guid: Optional[StrictStr] = None
    transaction_guids: Optional[conlist(StrictStr)] = None
    updated_at: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    __properties = ["actual_amount", "category_guid", "created_at", "guid", "item_type", "planned_amount", "scheduled_payment_guid", "spending_plan_iteration_guid", "top_level_category_guid", "transaction_guids", "updated_at", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SpendingPlanIterationItemResponse:
        """Create an instance of SpendingPlanIterationItemResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if actual_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.actual_amount is None and "actual_amount" in self.__fields_set__:
            _dict['actual_amount'] = None

        # set to None if category_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.category_guid is None and "category_guid" in self.__fields_set__:
            _dict['category_guid'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if item_type (nullable) is None
        # and __fields_set__ contains the field
        if self.item_type is None and "item_type" in self.__fields_set__:
            _dict['item_type'] = None

        # set to None if planned_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.planned_amount is None and "planned_amount" in self.__fields_set__:
            _dict['planned_amount'] = None

        # set to None if scheduled_payment_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.scheduled_payment_guid is None and "scheduled_payment_guid" in self.__fields_set__:
            _dict['scheduled_payment_guid'] = None

        # set to None if spending_plan_iteration_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.spending_plan_iteration_guid is None and "spending_plan_iteration_guid" in self.__fields_set__:
            _dict['spending_plan_iteration_guid'] = None

        # set to None if top_level_category_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.top_level_category_guid is None and "top_level_category_guid" in self.__fields_set__:
            _dict['top_level_category_guid'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SpendingPlanIterationItemResponse:
        """Create an instance of SpendingPlanIterationItemResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SpendingPlanIterationItemResponse.parse_obj(obj)

        _obj = SpendingPlanIterationItemResponse.parse_obj({
            "actual_amount": obj.get("actual_amount"),
            "category_guid": obj.get("category_guid"),
            "created_at": obj.get("created_at"),
            "guid": obj.get("guid"),
            "item_type": obj.get("item_type"),
            "planned_amount": obj.get("planned_amount"),
            "scheduled_payment_guid": obj.get("scheduled_payment_guid"),
            "spending_plan_iteration_guid": obj.get("spending_plan_iteration_guid"),
            "top_level_category_guid": obj.get("top_level_category_guid"),
            "transaction_guids": obj.get("transaction_guids"),
            "updated_at": obj.get("updated_at"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


