# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class ManagedTransactionCreateRequest(BaseModel):
    """
    ManagedTransactionCreateRequest
    """
    amount: StrictStr = Field(...)
    category: Optional[StrictStr] = None
    check_number_string: Optional[StrictStr] = None
    currency_code: Optional[StrictStr] = None
    description: StrictStr = Field(...)
    id: Optional[StrictStr] = None
    is_international: Optional[StrictBool] = None
    latitude: Optional[Union[StrictFloat, StrictInt]] = None
    localized_description: Optional[StrictStr] = None
    localized_memo: Optional[StrictStr] = None
    longitude: Optional[Union[StrictFloat, StrictInt]] = None
    memo: Optional[StrictStr] = None
    merchant_category_code: Optional[StrictInt] = None
    merchant_guid: Optional[StrictStr] = None
    merchant_location_guid: Optional[StrictStr] = None
    metadata: Optional[StrictStr] = None
    posted_at: StrictStr = Field(...)
    status: StrictStr = Field(...)
    transacted_at: StrictStr = Field(...)
    type: StrictStr = Field(...)
    __properties = ["amount", "category", "check_number_string", "currency_code", "description", "id", "is_international", "latitude", "localized_description", "localized_memo", "longitude", "memo", "merchant_category_code", "merchant_guid", "merchant_location_guid", "metadata", "posted_at", "status", "transacted_at", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ManagedTransactionCreateRequest:
        """Create an instance of ManagedTransactionCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ManagedTransactionCreateRequest:
        """Create an instance of ManagedTransactionCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ManagedTransactionCreateRequest.parse_obj(obj)

        _obj = ManagedTransactionCreateRequest.parse_obj({
            "amount": obj.get("amount"),
            "category": obj.get("category"),
            "check_number_string": obj.get("check_number_string"),
            "currency_code": obj.get("currency_code"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "is_international": obj.get("is_international"),
            "latitude": obj.get("latitude"),
            "localized_description": obj.get("localized_description"),
            "localized_memo": obj.get("localized_memo"),
            "longitude": obj.get("longitude"),
            "memo": obj.get("memo"),
            "merchant_category_code": obj.get("merchant_category_code"),
            "merchant_guid": obj.get("merchant_guid"),
            "merchant_location_guid": obj.get("merchant_location_guid"),
            "metadata": obj.get("metadata"),
            "posted_at": obj.get("posted_at"),
            "status": obj.get("status"),
            "transacted_at": obj.get("transacted_at"),
            "type": obj.get("type")
        })
        return _obj


