# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, StrictInt, StrictStr

class ProcessorAccountNumber(BaseModel):
    """
    ProcessorAccountNumber
    """
    account_number: Optional[StrictInt] = None
    guid: Optional[StrictStr] = None
    institution_number: Optional[Any] = None
    loan_guarantor: Optional[Any] = None
    loan_reference_number: Optional[Any] = None
    passed_validation: Optional[Any] = None
    routing_number: Optional[StrictInt] = None
    sequence_number: Optional[Any] = None
    transit_number: Optional[Any] = None
    __properties = ["account_number", "guid", "institution_number", "loan_guarantor", "loan_reference_number", "passed_validation", "routing_number", "sequence_number", "transit_number"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProcessorAccountNumber:
        """Create an instance of ProcessorAccountNumber from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if institution_number (nullable) is None
        # and __fields_set__ contains the field
        if self.institution_number is None and "institution_number" in self.__fields_set__:
            _dict['institution_number'] = None

        # set to None if loan_guarantor (nullable) is None
        # and __fields_set__ contains the field
        if self.loan_guarantor is None and "loan_guarantor" in self.__fields_set__:
            _dict['loan_guarantor'] = None

        # set to None if loan_reference_number (nullable) is None
        # and __fields_set__ contains the field
        if self.loan_reference_number is None and "loan_reference_number" in self.__fields_set__:
            _dict['loan_reference_number'] = None

        # set to None if passed_validation (nullable) is None
        # and __fields_set__ contains the field
        if self.passed_validation is None and "passed_validation" in self.__fields_set__:
            _dict['passed_validation'] = None

        # set to None if sequence_number (nullable) is None
        # and __fields_set__ contains the field
        if self.sequence_number is None and "sequence_number" in self.__fields_set__:
            _dict['sequence_number'] = None

        # set to None if transit_number (nullable) is None
        # and __fields_set__ contains the field
        if self.transit_number is None and "transit_number" in self.__fields_set__:
            _dict['transit_number'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProcessorAccountNumber:
        """Create an instance of ProcessorAccountNumber from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProcessorAccountNumber.parse_obj(obj)

        _obj = ProcessorAccountNumber.parse_obj({
            "account_number": obj.get("account_number"),
            "guid": obj.get("guid"),
            "institution_number": obj.get("institution_number"),
            "loan_guarantor": obj.get("loan_guarantor"),
            "loan_reference_number": obj.get("loan_reference_number"),
            "passed_validation": obj.get("passed_validation"),
            "routing_number": obj.get("routing_number"),
            "sequence_number": obj.get("sequence_number"),
            "transit_number": obj.get("transit_number")
        })
        return _obj


