# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictStr

class TaggingResponse(BaseModel):
    """
    TaggingResponse
    """
    guid: Optional[StrictStr] = None
    member_is_managed_by_user: Optional[StrictBool] = None
    tag_guid: Optional[StrictStr] = None
    transaction_guid: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    __properties = ["guid", "member_is_managed_by_user", "tag_guid", "transaction_guid", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaggingResponse:
        """Create an instance of TaggingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if member_is_managed_by_user (nullable) is None
        # and __fields_set__ contains the field
        if self.member_is_managed_by_user is None and "member_is_managed_by_user" in self.__fields_set__:
            _dict['member_is_managed_by_user'] = None

        # set to None if tag_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.tag_guid is None and "tag_guid" in self.__fields_set__:
            _dict['tag_guid'] = None

        # set to None if transaction_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.transaction_guid is None and "transaction_guid" in self.__fields_set__:
            _dict['transaction_guid'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TaggingResponse:
        """Create an instance of TaggingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TaggingResponse.parse_obj(obj)

        _obj = TaggingResponse.parse_obj({
            "guid": obj.get("guid"),
            "member_is_managed_by_user": obj.get("member_is_managed_by_user"),
            "tag_guid": obj.get("tag_guid"),
            "transaction_guid": obj.get("transaction_guid"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


