# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr

class ACHResponse(BaseModel):
    """
    ACHResponse
    """
    account_guid: Optional[StrictStr] = None
    account_number_last_four: Optional[StrictStr] = None
    account_type: Optional[StrictStr] = None
    ach_initiated_at: Optional[StrictStr] = None
    client_guid: Optional[StrictStr] = None
    corrected_account_number: Optional[StrictStr] = None
    corrected_routing_number: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    institution_guid: Optional[StrictStr] = None
    investigation_notes: Optional[StrictStr] = None
    member_guid: Optional[StrictStr] = None
    processing_errors: Optional[StrictStr] = None
    resolution_code: Optional[StrictStr] = None
    resolution_detail: Optional[StrictStr] = None
    resolved_status_at: Optional[StrictStr] = None
    return_code: Optional[StrictStr] = None
    return_notes: Optional[StrictStr] = None
    return_account_number: Optional[StrictStr] = None
    return_routing_number: Optional[StrictStr] = None
    return_status: Optional[StrictStr] = None
    returned_at: Optional[StrictStr] = None
    sec_code: Optional[StrictStr] = None
    started_processing_at: Optional[StrictStr] = None
    submitted_at: Optional[StrictStr] = None
    transaction_amount: Optional[Union[StrictFloat, StrictInt]] = None
    updated_at: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    __properties = ["account_guid", "account_number_last_four", "account_type", "ach_initiated_at", "client_guid", "corrected_account_number", "corrected_routing_number", "created_at", "guid", "id", "institution_guid", "investigation_notes", "member_guid", "processing_errors", "resolution_code", "resolution_detail", "resolved_status_at", "return_code", "return_notes", "return_account_number", "return_routing_number", "return_status", "returned_at", "sec_code", "started_processing_at", "submitted_at", "transaction_amount", "updated_at", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ACHResponse:
        """Create an instance of ACHResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if account_number_last_four (nullable) is None
        # and __fields_set__ contains the field
        if self.account_number_last_four is None and "account_number_last_four" in self.__fields_set__:
            _dict['account_number_last_four'] = None

        # set to None if account_type (nullable) is None
        # and __fields_set__ contains the field
        if self.account_type is None and "account_type" in self.__fields_set__:
            _dict['account_type'] = None

        # set to None if ach_initiated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.ach_initiated_at is None and "ach_initiated_at" in self.__fields_set__:
            _dict['ach_initiated_at'] = None

        # set to None if corrected_account_number (nullable) is None
        # and __fields_set__ contains the field
        if self.corrected_account_number is None and "corrected_account_number" in self.__fields_set__:
            _dict['corrected_account_number'] = None

        # set to None if corrected_routing_number (nullable) is None
        # and __fields_set__ contains the field
        if self.corrected_routing_number is None and "corrected_routing_number" in self.__fields_set__:
            _dict['corrected_routing_number'] = None

        # set to None if investigation_notes (nullable) is None
        # and __fields_set__ contains the field
        if self.investigation_notes is None and "investigation_notes" in self.__fields_set__:
            _dict['investigation_notes'] = None

        # set to None if processing_errors (nullable) is None
        # and __fields_set__ contains the field
        if self.processing_errors is None and "processing_errors" in self.__fields_set__:
            _dict['processing_errors'] = None

        # set to None if resolution_code (nullable) is None
        # and __fields_set__ contains the field
        if self.resolution_code is None and "resolution_code" in self.__fields_set__:
            _dict['resolution_code'] = None

        # set to None if resolution_detail (nullable) is None
        # and __fields_set__ contains the field
        if self.resolution_detail is None and "resolution_detail" in self.__fields_set__:
            _dict['resolution_detail'] = None

        # set to None if resolved_status_at (nullable) is None
        # and __fields_set__ contains the field
        if self.resolved_status_at is None and "resolved_status_at" in self.__fields_set__:
            _dict['resolved_status_at'] = None

        # set to None if return_notes (nullable) is None
        # and __fields_set__ contains the field
        if self.return_notes is None and "return_notes" in self.__fields_set__:
            _dict['return_notes'] = None

        # set to None if return_account_number (nullable) is None
        # and __fields_set__ contains the field
        if self.return_account_number is None and "return_account_number" in self.__fields_set__:
            _dict['return_account_number'] = None

        # set to None if return_routing_number (nullable) is None
        # and __fields_set__ contains the field
        if self.return_routing_number is None and "return_routing_number" in self.__fields_set__:
            _dict['return_routing_number'] = None

        # set to None if return_status (nullable) is None
        # and __fields_set__ contains the field
        if self.return_status is None and "return_status" in self.__fields_set__:
            _dict['return_status'] = None

        # set to None if returned_at (nullable) is None
        # and __fields_set__ contains the field
        if self.returned_at is None and "returned_at" in self.__fields_set__:
            _dict['returned_at'] = None

        # set to None if sec_code (nullable) is None
        # and __fields_set__ contains the field
        if self.sec_code is None and "sec_code" in self.__fields_set__:
            _dict['sec_code'] = None

        # set to None if started_processing_at (nullable) is None
        # and __fields_set__ contains the field
        if self.started_processing_at is None and "started_processing_at" in self.__fields_set__:
            _dict['started_processing_at'] = None

        # set to None if submitted_at (nullable) is None
        # and __fields_set__ contains the field
        if self.submitted_at is None and "submitted_at" in self.__fields_set__:
            _dict['submitted_at'] = None

        # set to None if transaction_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.transaction_amount is None and "transaction_amount" in self.__fields_set__:
            _dict['transaction_amount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ACHResponse:
        """Create an instance of ACHResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ACHResponse.parse_obj(obj)

        _obj = ACHResponse.parse_obj({
            "account_guid": obj.get("account_guid"),
            "account_number_last_four": obj.get("account_number_last_four"),
            "account_type": obj.get("account_type"),
            "ach_initiated_at": obj.get("ach_initiated_at"),
            "client_guid": obj.get("client_guid"),
            "corrected_account_number": obj.get("corrected_account_number"),
            "corrected_routing_number": obj.get("corrected_routing_number"),
            "created_at": obj.get("created_at"),
            "guid": obj.get("guid"),
            "id": obj.get("id"),
            "institution_guid": obj.get("institution_guid"),
            "investigation_notes": obj.get("investigation_notes"),
            "member_guid": obj.get("member_guid"),
            "processing_errors": obj.get("processing_errors"),
            "resolution_code": obj.get("resolution_code"),
            "resolution_detail": obj.get("resolution_detail"),
            "resolved_status_at": obj.get("resolved_status_at"),
            "return_code": obj.get("return_code"),
            "return_notes": obj.get("return_notes"),
            "return_account_number": obj.get("return_account_number"),
            "return_routing_number": obj.get("return_routing_number"),
            "return_status": obj.get("return_status"),
            "returned_at": obj.get("returned_at"),
            "sec_code": obj.get("sec_code"),
            "started_processing_at": obj.get("started_processing_at"),
            "submitted_at": obj.get("submitted_at"),
            "transaction_amount": obj.get("transaction_amount"),
            "updated_at": obj.get("updated_at"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


