# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from mx_platform_python.models.member_create_request import MemberCreateRequest

class MemberCreateRequestBody(BaseModel):
    """
    MemberCreateRequestBody
    """
    client_redirect_url: Optional[StrictStr] = None
    enable_app2app: Optional[StrictBool] = Field(None, description="This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, any `oauth_window_uri` generated will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions. ")
    member: Optional[MemberCreateRequest] = None
    referral_source: Optional[StrictStr] = None
    ui_message_webview_url_scheme: Optional[StrictStr] = None
    __properties = ["client_redirect_url", "enable_app2app", "member", "referral_source", "ui_message_webview_url_scheme"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MemberCreateRequestBody:
        """Create an instance of MemberCreateRequestBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of member
        if self.member:
            _dict['member'] = self.member.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MemberCreateRequestBody:
        """Create an instance of MemberCreateRequestBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MemberCreateRequestBody.parse_obj(obj)

        _obj = MemberCreateRequestBody.parse_obj({
            "client_redirect_url": obj.get("client_redirect_url"),
            "enable_app2app": obj.get("enable_app2app"),
            "member": MemberCreateRequest.from_dict(obj.get("member")) if obj.get("member") is not None else None,
            "referral_source": obj.get("referral_source"),
            "ui_message_webview_url_scheme": obj.get("ui_message_webview_url_scheme")
        })
        return _obj


