# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictBool, StrictStr, conlist
from mx_platform_python.models.challenge_response import ChallengeResponse

class MemberStatusResponse(BaseModel):
    """
    MemberStatusResponse
    """
    aggregated_at: Optional[StrictStr] = None
    challenges: Optional[conlist(ChallengeResponse)] = None
    connection_status: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    has_processed_account_numbers: Optional[StrictBool] = None
    has_processed_accounts: Optional[StrictBool] = None
    has_processed_transactions: Optional[StrictBool] = None
    is_authenticated: Optional[StrictBool] = None
    is_being_aggregated: Optional[StrictBool] = None
    successfully_aggregated_at: Optional[StrictStr] = None
    __properties = ["aggregated_at", "challenges", "connection_status", "guid", "has_processed_account_numbers", "has_processed_accounts", "has_processed_transactions", "is_authenticated", "is_being_aggregated", "successfully_aggregated_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MemberStatusResponse:
        """Create an instance of MemberStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in challenges (list)
        _items = []
        if self.challenges:
            for _item in self.challenges:
                if _item:
                    _items.append(_item.to_dict())
            _dict['challenges'] = _items
        # set to None if aggregated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.aggregated_at is None and "aggregated_at" in self.__fields_set__:
            _dict['aggregated_at'] = None

        # set to None if connection_status (nullable) is None
        # and __fields_set__ contains the field
        if self.connection_status is None and "connection_status" in self.__fields_set__:
            _dict['connection_status'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if has_processed_account_numbers (nullable) is None
        # and __fields_set__ contains the field
        if self.has_processed_account_numbers is None and "has_processed_account_numbers" in self.__fields_set__:
            _dict['has_processed_account_numbers'] = None

        # set to None if has_processed_accounts (nullable) is None
        # and __fields_set__ contains the field
        if self.has_processed_accounts is None and "has_processed_accounts" in self.__fields_set__:
            _dict['has_processed_accounts'] = None

        # set to None if has_processed_transactions (nullable) is None
        # and __fields_set__ contains the field
        if self.has_processed_transactions is None and "has_processed_transactions" in self.__fields_set__:
            _dict['has_processed_transactions'] = None

        # set to None if is_authenticated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_authenticated is None and "is_authenticated" in self.__fields_set__:
            _dict['is_authenticated'] = None

        # set to None if is_being_aggregated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_being_aggregated is None and "is_being_aggregated" in self.__fields_set__:
            _dict['is_being_aggregated'] = None

        # set to None if successfully_aggregated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.successfully_aggregated_at is None and "successfully_aggregated_at" in self.__fields_set__:
            _dict['successfully_aggregated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MemberStatusResponse:
        """Create an instance of MemberStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MemberStatusResponse.parse_obj(obj)

        _obj = MemberStatusResponse.parse_obj({
            "aggregated_at": obj.get("aggregated_at"),
            "challenges": [ChallengeResponse.from_dict(_item) for _item in obj.get("challenges")] if obj.get("challenges") is not None else None,
            "connection_status": obj.get("connection_status"),
            "guid": obj.get("guid"),
            "has_processed_account_numbers": obj.get("has_processed_account_numbers"),
            "has_processed_accounts": obj.get("has_processed_accounts"),
            "has_processed_transactions": obj.get("has_processed_transactions"),
            "is_authenticated": obj.get("is_authenticated"),
            "is_being_aggregated": obj.get("is_being_aggregated"),
            "successfully_aggregated_at": obj.get("successfully_aggregated_at")
        })
        return _obj


