# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, conlist
from mx_platform_python.models.processor_account_number_body_account_numbers_inner import ProcessorAccountNumberBodyAccountNumbersInner

class ProcessorAccountNumberBody(BaseModel):
    """
    ProcessorAccountNumberBody
    """
    account_numbers: Optional[conlist(ProcessorAccountNumberBodyAccountNumbersInner)] = None
    __properties = ["account_numbers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProcessorAccountNumberBody:
        """Create an instance of ProcessorAccountNumberBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in account_numbers (list)
        _items = []
        if self.account_numbers:
            for _item in self.account_numbers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['account_numbers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProcessorAccountNumberBody:
        """Create an instance of ProcessorAccountNumberBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProcessorAccountNumberBody.parse_obj(obj)

        _obj = ProcessorAccountNumberBody.parse_obj({
            "account_numbers": [ProcessorAccountNumberBodyAccountNumbersInner.from_dict(_item) for _item in obj.get("account_numbers")] if obj.get("account_numbers") is not None else None
        })
        return _obj


