# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr, conlist

from typing import Optional

from mx_platform_python.models.enhance_transactions_request_body import EnhanceTransactionsRequestBody
from mx_platform_python.models.enhance_transactions_response_body import EnhanceTransactionsResponseBody
from mx_platform_python.models.member_response_body import MemberResponseBody
from mx_platform_python.models.repeating_transactions_response_body import RepeatingTransactionsResponseBody
from mx_platform_python.models.split_transaction_request_body import SplitTransactionRequestBody
from mx_platform_python.models.split_transactions_response_body import SplitTransactionsResponseBody
from mx_platform_python.models.transaction_create_request_body import TransactionCreateRequestBody
from mx_platform_python.models.transaction_create_response_body import TransactionCreateResponseBody
from mx_platform_python.models.transaction_response_body import TransactionResponseBody
from mx_platform_python.models.transaction_update_request_body import TransactionUpdateRequestBody
from mx_platform_python.models.transactions_response_body_includes import TransactionsResponseBodyIncludes

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TransactionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_manual_transaction(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], transaction_create_request_body : TransactionCreateRequestBody, **kwargs) -> TransactionCreateResponseBody:  # noqa: E501
        """Create manual transaction  # noqa: E501

        This endpoint can only be used to create manual transactions that are under a manual account. This endpoint accepts the optional MX-Skip-Webhook header and skip_webhook parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_transaction(user_guid, account_guid, transaction_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param transaction_create_request_body: (required)
        :type transaction_create_request_body: TransactionCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionCreateResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_manual_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_manual_transaction_with_http_info(user_guid, account_guid, transaction_create_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_manual_transaction_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], transaction_create_request_body : TransactionCreateRequestBody, **kwargs) -> ApiResponse:  # noqa: E501
        """Create manual transaction  # noqa: E501

        This endpoint can only be used to create manual transactions that are under a manual account. This endpoint accepts the optional MX-Skip-Webhook header and skip_webhook parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_transaction_with_http_info(user_guid, account_guid, transaction_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param transaction_create_request_body: (required)
        :type transaction_create_request_body: TransactionCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionCreateResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'account_guid',
            'transaction_create_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_manual_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_create_request_body'] is not None:
            _body_params = _params['transaction_create_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionCreateResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}/transactions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_split_transactions(self, transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], split_transaction_request_body : Optional[SplitTransactionRequestBody] = None, **kwargs) -> SplitTransactionsResponseBody:  # noqa: E501
        """Create split transactions  # noqa: E501

        This endpoint creates two or more child transactions that are branched from a previous transaction. This endpoint allows you to link multiple categories, descriptions, and amounts to a parent transaction.  When a split transaction is created, the parent transaction's `has_been_split` field will automatically be updated to true and the child transactions' `parent_guid` will have the transaction guid of the parent. The total amount of the child transactions must equal the amount of the parent transaction. Once a transaction has been split it can't be split again.    In order to re-split a transaction, it must first be un-split. This can be done by calling the Delete Split Transactions endpoint. Calling this endpoint will delete the existing child transactions and update the parent transaction's `has_been_split` field to false. You can then re-split the parent transaction by calling Create Split Transaction again.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_split_transactions(transaction_guid, user_guid, split_transaction_request_body, async_req=True)
        >>> result = thread.get()

        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param split_transaction_request_body:
        :type split_transaction_request_body: SplitTransactionRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitTransactionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_split_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_split_transactions_with_http_info(transaction_guid, user_guid, split_transaction_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_split_transactions_with_http_info(self, transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], split_transaction_request_body : Optional[SplitTransactionRequestBody] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create split transactions  # noqa: E501

        This endpoint creates two or more child transactions that are branched from a previous transaction. This endpoint allows you to link multiple categories, descriptions, and amounts to a parent transaction.  When a split transaction is created, the parent transaction's `has_been_split` field will automatically be updated to true and the child transactions' `parent_guid` will have the transaction guid of the parent. The total amount of the child transactions must equal the amount of the parent transaction. Once a transaction has been split it can't be split again.    In order to re-split a transaction, it must first be un-split. This can be done by calling the Delete Split Transactions endpoint. Calling this endpoint will delete the existing child transactions and update the parent transaction's `has_been_split` field to false. You can then re-split the parent transaction by calling Create Split Transaction again.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_split_transactions_with_http_info(transaction_guid, user_guid, split_transaction_request_body, async_req=True)
        >>> result = thread.get()

        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param split_transaction_request_body:
        :type split_transaction_request_body: SplitTransactionRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitTransactionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transaction_guid',
            'user_guid',
            'split_transaction_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_split_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['split_transaction_request_body'] is not None:
            _body_params = _params['split_transaction_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SplitTransactionsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/transactions/{transaction_guid}/split', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_manual_transactions(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], **kwargs) -> None:  # noqa: E501
        """Delete manual transactions  # noqa: E501

        Delete a manual transaction. In the path, use the manual transaction guid as the `transaction_guid`, such as `MAN-810828b0-5210-4878-9bd3-f4ce514f90c4`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_manual_transactions(user_guid, transaction_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_manual_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_manual_transactions_with_http_info(user_guid, transaction_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_manual_transactions_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete manual transactions  # noqa: E501

        Delete a manual transaction. In the path, use the manual transaction guid as the `transaction_guid`, such as `MAN-810828b0-5210-4878-9bd3-f4ce514f90c4`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_manual_transactions_with_http_info(user_guid, transaction_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'transaction_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_manual_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/transactions/{transaction_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_split_transactions(self, transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> None:  # noqa: E501
        """Delete split transactions  # noqa: E501

        This endpoint deletes all split transactions linked to a parent transaction, but it leaves the parent transaction active. This request will also update the parent transaction's has_been_split field to false. This endpoint accepts the optional MX-Skip-Webhook header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_split_transactions(transaction_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_split_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_split_transactions_with_http_info(transaction_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_split_transactions_with_http_info(self, transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete split transactions  # noqa: E501

        This endpoint deletes all split transactions linked to a parent transaction, but it leaves the parent transaction active. This request will also update the parent transaction's has_been_split field to false. This endpoint accepts the optional MX-Skip-Webhook header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_split_transactions_with_http_info(transaction_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'transaction_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_split_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/transactions/{transaction_guid}/split', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_transaction_rule(self, transaction_rule_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction_rule`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> None:  # noqa: E501
        """Delete transaction rule  # noqa: E501

        Use this endpoint to permanently delete a transaction rule based on its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_rule(transaction_rule_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param transaction_rule_guid: The unique id for a `transaction_rule`. (required)
        :type transaction_rule_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transaction_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_transaction_rule_with_http_info(transaction_rule_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transaction_rule_with_http_info(self, transaction_rule_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction_rule`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete transaction rule  # noqa: E501

        Use this endpoint to permanently delete a transaction rule based on its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_rule_with_http_info(transaction_rule_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param transaction_rule_guid: The unique id for a `transaction_rule`. (required)
        :type transaction_rule_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'transaction_rule_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['transaction_rule_guid']:
            _path_params['transaction_rule_guid'] = _params['transaction_rule_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/transaction_rules/{transaction_rule_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enhance_transactions(self, enhance_transactions_request_body : Annotated[EnhanceTransactionsRequestBody, Field(..., description="Transaction object to be enhanced")], **kwargs) -> EnhanceTransactionsResponseBody:  # noqa: E501
        """Enhance transactions  # noqa: E501

        Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform. <br /><br />For more information on returned data, please see the [Enhanced Transactions fields guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enhance_transactions(enhance_transactions_request_body, async_req=True)
        >>> result = thread.get()

        :param enhance_transactions_request_body: Transaction object to be enhanced (required)
        :type enhance_transactions_request_body: EnhanceTransactionsRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EnhanceTransactionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the enhance_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.enhance_transactions_with_http_info(enhance_transactions_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def enhance_transactions_with_http_info(self, enhance_transactions_request_body : Annotated[EnhanceTransactionsRequestBody, Field(..., description="Transaction object to be enhanced")], **kwargs) -> ApiResponse:  # noqa: E501
        """Enhance transactions  # noqa: E501

        Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform. <br /><br />For more information on returned data, please see the [Enhanced Transactions fields guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enhance_transactions_with_http_info(enhance_transactions_request_body, async_req=True)
        >>> result = thread.get()

        :param enhance_transactions_request_body: Transaction object to be enhanced (required)
        :type enhance_transactions_request_body: EnhanceTransactionsRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EnhanceTransactionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'enhance_transactions_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enhance_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['enhance_transactions_request_body'] is not None:
            _body_params = _params['enhance_transactions_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "EnhanceTransactionsResponseBody",
        }

        return self.api_client.call_api(
            '/transactions/enhance', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def extend_history(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> MemberResponseBody:  # noqa: E501
        """Extend history  # noqa: E501

        Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extend_history(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MemberResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the extend_history_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.extend_history_with_http_info(member_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def extend_history_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Extend history  # noqa: E501

        Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extend_history_with_http_info(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MemberResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method extend_history" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '202': "MemberResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/extend_history', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_transactions(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> TransactionsResponseBodyIncludes:  # noqa: E501
        """List transactions  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `user`, across all members and accounts associated with that `user`. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions(user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBodyIncludes
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_transactions_with_http_info(user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transactions_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List transactions  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `user`, across all members and accounts associated with that `user`. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_with_http_info(user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBodyIncludes, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'page',
            'records_per_page',
            'from_date',
            'to_date',
            'from_created_at',
            'to_created_at',
            'from_updated_at',
            'to_updated_at',
            'category_guid',
            'category_guid2',
            'top_level_category_guid',
            'top_level_category_guid2',
            'use_case',
            'includes'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))

        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))

        if _params.get('from_created_at') is not None:  # noqa: E501
            _query_params.append(('from_created_at', _params['from_created_at']))

        if _params.get('to_created_at') is not None:  # noqa: E501
            _query_params.append(('to_created_at', _params['to_created_at']))

        if _params.get('from_updated_at') is not None:  # noqa: E501
            _query_params.append(('from_updated_at', _params['from_updated_at']))

        if _params.get('to_updated_at') is not None:  # noqa: E501
            _query_params.append(('to_updated_at', _params['to_updated_at']))

        if _params.get('category_guid') is not None:  # noqa: E501
            _query_params.append(('category_guid', _params['category_guid']))

        if _params.get('category_guid2') is not None:  # noqa: E501
            _query_params.append(('category_guid[]', _params['category_guid2']))
            _collection_formats['category_guid[]'] = 'multi'

        if _params.get('top_level_category_guid') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid', _params['top_level_category_guid']))

        if _params.get('top_level_category_guid2') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid[]', _params['top_level_category_guid2']))
            _collection_formats['top_level_category_guid[]'] = 'multi'

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('use_case', _params['use_case']))

        if _params.get('includes') is not None:  # noqa: E501
            _query_params.append(('includes', _params['includes']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBodyIncludes",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_transactions_by_account(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> TransactionsResponseBodyIncludes:  # noqa: E501
        """List transactions by account  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified account. <br /><br /> Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_account(account_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBodyIncludes
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transactions_by_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_transactions_by_account_with_http_info(account_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transactions_by_account_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List transactions by account  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified account. <br /><br /> Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_account_with_http_info(account_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBodyIncludes, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'user_guid',
            'page',
            'records_per_page',
            'from_date',
            'to_date',
            'from_created_at',
            'to_created_at',
            'from_updated_at',
            'to_updated_at',
            'category_guid',
            'category_guid2',
            'top_level_category_guid',
            'top_level_category_guid2',
            'includes'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions_by_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))

        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))

        if _params.get('from_created_at') is not None:  # noqa: E501
            _query_params.append(('from_created_at', _params['from_created_at']))

        if _params.get('to_created_at') is not None:  # noqa: E501
            _query_params.append(('to_created_at', _params['to_created_at']))

        if _params.get('from_updated_at') is not None:  # noqa: E501
            _query_params.append(('from_updated_at', _params['from_updated_at']))

        if _params.get('to_updated_at') is not None:  # noqa: E501
            _query_params.append(('to_updated_at', _params['to_updated_at']))

        if _params.get('category_guid') is not None:  # noqa: E501
            _query_params.append(('category_guid', _params['category_guid']))

        if _params.get('category_guid2') is not None:  # noqa: E501
            _query_params.append(('category_guid[]', _params['category_guid2']))
            _collection_formats['category_guid[]'] = 'multi'

        if _params.get('top_level_category_guid') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid', _params['top_level_category_guid']))

        if _params.get('top_level_category_guid2') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid[]', _params['top_level_category_guid2']))
            _collection_formats['top_level_category_guid[]'] = 'multi'

        if _params.get('includes') is not None:  # noqa: E501
            _query_params.append(('includes', _params['includes']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBodyIncludes",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_transactions_by_member(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> TransactionsResponseBodyIncludes:  # noqa: E501
        """List transactions by member  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `member`, across all accounts associated with that `member`. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_member(member_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBodyIncludes
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transactions_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_transactions_by_member_with_http_info(member_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transactions_by_member_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List transactions by member  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `member`, across all accounts associated with that `member`. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_member_with_http_info(member_guid, user_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, includes, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBodyIncludes, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid',
            'page',
            'records_per_page',
            'from_date',
            'to_date',
            'from_created_at',
            'to_created_at',
            'from_updated_at',
            'to_updated_at',
            'category_guid',
            'category_guid2',
            'top_level_category_guid',
            'top_level_category_guid2',
            'includes'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))

        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))

        if _params.get('from_created_at') is not None:  # noqa: E501
            _query_params.append(('from_created_at', _params['from_created_at']))

        if _params.get('to_created_at') is not None:  # noqa: E501
            _query_params.append(('to_created_at', _params['to_created_at']))

        if _params.get('from_updated_at') is not None:  # noqa: E501
            _query_params.append(('from_updated_at', _params['from_updated_at']))

        if _params.get('to_updated_at') is not None:  # noqa: E501
            _query_params.append(('to_updated_at', _params['to_updated_at']))

        if _params.get('category_guid') is not None:  # noqa: E501
            _query_params.append(('category_guid', _params['category_guid']))

        if _params.get('category_guid2') is not None:  # noqa: E501
            _query_params.append(('category_guid[]', _params['category_guid2']))
            _collection_formats['category_guid[]'] = 'multi'

        if _params.get('top_level_category_guid') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid', _params['top_level_category_guid']))

        if _params.get('top_level_category_guid2') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid[]', _params['top_level_category_guid2']))
            _collection_formats['top_level_category_guid[]'] = 'multi'

        if _params.get('includes') is not None:  # noqa: E501
            _query_params.append(('includes', _params['includes']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBodyIncludes",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_transactions_by_tag(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> TransactionsResponseBodyIncludes:  # noqa: E501
        """List transactions by tag  # noqa: E501

        Use this endpoint to get a list of all transactions associated with a particular tag according to the tag's unique GUID. This lists all transactions that have been assigned to a particular tag using the create tagging endpoint. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_tag(user_guid, tag_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBodyIncludes
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transactions_by_tag_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_transactions_by_tag_with_http_info(user_guid, tag_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transactions_by_tag_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], tag_guid : Annotated[StrictStr, Field(..., description="The unique id for a `tag`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, from_date : Annotated[Optional[StrictStr], Field(description="Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.")] = None, to_date : Annotated[Optional[StrictStr], Field(description="Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.")] = None, from_created_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_created_at : Annotated[Optional[StrictStr], Field(description="Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, from_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, to_updated_at : Annotated[Optional[StrictStr], Field(description="Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.")] = None, category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid : Annotated[Optional[StrictStr], Field(description="Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, top_level_category_guid2 : Annotated[Optional[conlist(StrictStr)], Field(description="Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List transactions by tag  # noqa: E501

        Use this endpoint to get a list of all transactions associated with a particular tag according to the tag's unique GUID. This lists all transactions that have been assigned to a particular tag using the create tagging endpoint. <br /><br />Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_tag_with_http_info(user_guid, tag_guid, page, records_per_page, from_date, to_date, from_created_at, to_created_at, from_updated_at, to_updated_at, category_guid, category_guid2, top_level_category_guid, top_level_category_guid2, use_case, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param tag_guid: The unique id for a `tag`. (required)
        :type tag_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param from_date: Filter transactions from this date. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 120 days ago if not provided.
        :type from_date: str
        :param to_date: Filter transactions to this date (at midnight). This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Defaults to 5 days forward from the day the request is made to capture pending transactions.
        :type to_date: str
        :param from_created_at: Filter transactions from the date the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_created_at: str
        :param to_created_at: Filter transaction to the date in which the transaction was created. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_created_at: str
        :param from_updated_at: Filter transactions from the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type from_updated_at: str
        :param to_updated_at: Filter transactions to the date in which the transaction was updated. This only supports ISO 8601 format without timestamp (YYYY-MM-DD). Maximum date range limit is 6 months.
        :type to_updated_at: str
        :param category_guid: Filter transactions belonging to specified `category_guid`.  For example, `?category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid: str
        :param category_guid2: Filter transactions belonging to any specified `category_guid[]` in url.  For example, `?category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type category_guid2: List[str]
        :param top_level_category_guid: Filter transactions belonging to specified `top_level_category_guid`. This must be top level category guid, use `category_guid` for subcategory guid.  For example, `?top_level_category_guid=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid: str
        :param top_level_category_guid2: Filter transactions belonging to any specified `top_level_category_guid[]` in url. This must be top level category guid(s), use `category_guid` for subcategory guid(s).  For example, `?top_level_category_guid[]=CAT-7829f71c-2e8c-afa5-2f55-fa3634b89874`.
        :type top_level_category_guid2: List[str]
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBodyIncludes, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'tag_guid',
            'page',
            'records_per_page',
            'from_date',
            'to_date',
            'from_created_at',
            'to_created_at',
            'from_updated_at',
            'to_updated_at',
            'category_guid',
            'category_guid2',
            'top_level_category_guid',
            'top_level_category_guid2',
            'use_case',
            'includes'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions_by_tag" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['tag_guid']:
            _path_params['tag_guid'] = _params['tag_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('from_date') is not None:  # noqa: E501
            _query_params.append(('from_date', _params['from_date']))

        if _params.get('to_date') is not None:  # noqa: E501
            _query_params.append(('to_date', _params['to_date']))

        if _params.get('from_created_at') is not None:  # noqa: E501
            _query_params.append(('from_created_at', _params['from_created_at']))

        if _params.get('to_created_at') is not None:  # noqa: E501
            _query_params.append(('to_created_at', _params['to_created_at']))

        if _params.get('from_updated_at') is not None:  # noqa: E501
            _query_params.append(('from_updated_at', _params['from_updated_at']))

        if _params.get('to_updated_at') is not None:  # noqa: E501
            _query_params.append(('to_updated_at', _params['to_updated_at']))

        if _params.get('category_guid') is not None:  # noqa: E501
            _query_params.append(('category_guid', _params['category_guid']))

        if _params.get('category_guid2') is not None:  # noqa: E501
            _query_params.append(('category_guid[]', _params['category_guid2']))
            _collection_formats['category_guid[]'] = 'multi'

        if _params.get('top_level_category_guid') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid', _params['top_level_category_guid']))

        if _params.get('top_level_category_guid2') is not None:  # noqa: E501
            _query_params.append(('top_level_category_guid[]', _params['top_level_category_guid2']))
            _collection_formats['top_level_category_guid[]'] = 'multi'

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('use_case', _params['use_case']))

        if _params.get('includes') is not None:  # noqa: E501
            _query_params.append(('includes', _params['includes']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBodyIncludes",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/tags/{tag_guid}/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_transaction(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> TransactionsResponseBodyIncludes:  # noqa: E501
        """Read transaction  # noqa: E501

        Requests to this endpoint will return the attributes of the specified `transaction`. To read a manual transaction, use the manual transaction guid in the path as the `transactionGuid`. <br /><br /> Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transaction(user_guid, transaction_guid, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBodyIncludes
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_transaction_with_http_info(user_guid, transaction_guid, includes, **kwargs)  # noqa: E501

    @validate_arguments
    def read_transaction_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], includes : Annotated[Optional[StrictStr], Field(description="Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Read transaction  # noqa: E501

        Requests to this endpoint will return the attributes of the specified `transaction`. To read a manual transaction, use the manual transaction guid in the path as the `transactionGuid`. <br /><br /> Enhanced transaction data may be requested using the `includes` parameter. To use this optional parameter, the value should include the optional metadata requested such as `repeating_transactions`, `merchants`, `classifications`, `geolocations`. For more information, see the [Optional Enhancement Query Parameter guide](/api-reference/platform-api/reference/transactions-overview#enhanced-transactions#optional-enhancement-query-parameter).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transaction_with_http_info(user_guid, transaction_guid, includes, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param includes: Options for enhanced transactions. This query parameter is optional. Possible additional metadata: `repeating_transactions`, `merchants`, `classifications`, `geolocations`. The query value is format sensitive. To retrieve all available enhancements, append:  `?includes=repeating_transactions,merchants,classifications,geolocations`.    The query options may be combined to specific enhancements. For example, to request Repeating Transactions and Geolocation data, use:   `?includes=repeating_transactions,geolocations`.  - Repeating Transactions: Identifies transactions with predictable recurrence patterns (e.g., Bill, Income, Subscription). - Merchants: Enriches transactions with merchant name. - Classifications: Provides more insight into the type of money movement that is occurring on the transaction, whether it be retail or investments. - Geolocation: Provides geographic metadata. 
        :type includes: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBodyIncludes, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'transaction_guid',
            'includes'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']


        # process the query parameters
        _query_params = []
        if _params.get('includes') is not None:  # noqa: E501
            _query_params.append(('includes', _params['includes']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBodyIncludes",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/transactions/{transaction_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def repeating_transactions(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> RepeatingTransactionsResponseBody:  # noqa: E501
        """List Repeating Transactions  # noqa: E501

        Retrieve a list of all recurring transactions for a user. <br /><br />For more see the [Repeating Transactions guide](/api-reference/platform-api/v20111101/reference/transactions-overview#repeating-transactions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.repeating_transactions(user_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RepeatingTransactionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the repeating_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.repeating_transactions_with_http_info(user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def repeating_transactions_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """List Repeating Transactions  # noqa: E501

        Retrieve a list of all recurring transactions for a user. <br /><br />For more see the [Repeating Transactions guide](/api-reference/platform-api/v20111101/reference/transactions-overview#repeating-transactions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.repeating_transactions_with_http_info(user_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RepeatingTransactionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repeating_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "RepeatingTransactionsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/repeating_transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def specific_repeating_transaction(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], repeating_transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a recurring transaction.")], **kwargs) -> RepeatingTransactionsResponseBody:  # noqa: E501
        """Get a Repeating Transaction  # noqa: E501

        Get a Specific Repeating Transaction. <br /><br />List For more see the  [Repeating Transactions guide](/api-reference/platform-api/v20111101/reference/transactions-overview#repeating-transactions)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.specific_repeating_transaction(user_guid, repeating_transaction_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param repeating_transaction_guid: The unique id for a recurring transaction. (required)
        :type repeating_transaction_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RepeatingTransactionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the specific_repeating_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.specific_repeating_transaction_with_http_info(user_guid, repeating_transaction_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def specific_repeating_transaction_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], repeating_transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a recurring transaction.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a Repeating Transaction  # noqa: E501

        Get a Specific Repeating Transaction. <br /><br />List For more see the  [Repeating Transactions guide](/api-reference/platform-api/v20111101/reference/transactions-overview#repeating-transactions)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.specific_repeating_transaction_with_http_info(user_guid, repeating_transaction_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param repeating_transaction_guid: The unique id for a recurring transaction. (required)
        :type repeating_transaction_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RepeatingTransactionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'repeating_transaction_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method specific_repeating_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['repeating_transaction_guid']:
            _path_params['repeating_transaction_guid'] = _params['repeating_transaction_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "RepeatingTransactionsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/repeating_transactions/{repeating_transaction_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_transaction(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], transaction_update_request_body : Annotated[TransactionUpdateRequestBody, Field(..., description="Transaction object with the fields to be updated.")], **kwargs) -> TransactionResponseBody:  # noqa: E501
        """Update transaction  # noqa: E501

        Use this endpoint to update a specific transaction according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction(user_guid, transaction_guid, transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param transaction_update_request_body: Transaction object with the fields to be updated. (required)
        :type transaction_update_request_body: TransactionUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_transaction_with_http_info(user_guid, transaction_guid, transaction_update_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_transaction_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], transaction_update_request_body : Annotated[TransactionUpdateRequestBody, Field(..., description="Transaction object with the fields to be updated.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update transaction  # noqa: E501

        Use this endpoint to update a specific transaction according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_with_http_info(user_guid, transaction_guid, transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param transaction_update_request_body: Transaction object with the fields to be updated. (required)
        :type transaction_update_request_body: TransactionUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'transaction_guid',
            'transaction_update_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_update_request_body'] is not None:
            _body_params = _params['transaction_update_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/transactions/{transaction_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_transaction_by_account(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], transaction_update_request_body : Annotated[TransactionUpdateRequestBody, Field(..., description="Transaction object to be updated")], **kwargs) -> TransactionResponseBody:  # noqa: E501
        """Update Transaction by Account  # noqa: E501

        Use this endpoint to update a specific transaction according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_by_account(user_guid, member_guid, account_guid, transaction_guid, transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param transaction_update_request_body: Transaction object to be updated (required)
        :type transaction_update_request_body: TransactionUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_transaction_by_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_transaction_by_account_with_http_info(user_guid, member_guid, account_guid, transaction_guid, transaction_update_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_transaction_by_account_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], transaction_guid : Annotated[StrictStr, Field(..., description="The unique id for a `transaction`.")], transaction_update_request_body : Annotated[TransactionUpdateRequestBody, Field(..., description="Transaction object to be updated")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Transaction by Account  # noqa: E501

        Use this endpoint to update a specific transaction according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_by_account_with_http_info(user_guid, member_guid, account_guid, transaction_guid, transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param transaction_guid: The unique id for a `transaction`. (required)
        :type transaction_guid: str
        :param transaction_update_request_body: Transaction object to be updated (required)
        :type transaction_update_request_body: TransactionUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'member_guid',
            'account_guid',
            'transaction_guid',
            'transaction_update_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction_by_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['transaction_guid']:
            _path_params['transaction_guid'] = _params['transaction_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_update_request_body'] is not None:
            _body_params = _params['transaction_update_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
