# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr

class InvestmentHoldingResponse(BaseModel):
    """
    InvestmentHoldingResponse
    """
    account_guid: Optional[StrictStr] = None
    cost_basis: Optional[Union[StrictFloat, StrictInt]] = None
    coupon_yield: Optional[StrictStr] = None
    currency_code: Optional[StrictStr] = None
    current_price: Optional[Union[StrictFloat, StrictInt]] = None
    daily_change: Optional[Union[StrictFloat, StrictInt]] = None
    description: Optional[StrictStr] = None
    expiration: Optional[StrictStr] = None
    face_value: Optional[Union[StrictFloat, StrictInt]] = None
    frequency: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    market_value: Optional[Union[StrictFloat, StrictInt]] = None
    maturity_date: Optional[StrictStr] = None
    percentage_change: Optional[Union[StrictFloat, StrictInt]] = None
    purchase_price: Optional[Union[StrictFloat, StrictInt]] = None
    quantity: Optional[StrictStr] = None
    rate: Optional[Union[StrictFloat, StrictInt]] = None
    strike_price: Optional[Union[StrictFloat, StrictInt]] = None
    symbol: Optional[StrictStr] = None
    term: Optional[StrictStr] = None
    today_ugl_amount: Optional[Union[StrictFloat, StrictInt]] = None
    today_ugl_percentage: Optional[Union[StrictFloat, StrictInt]] = None
    total_ugl_amount: Optional[Union[StrictFloat, StrictInt]] = None
    total_ugl_percentage: Optional[Union[StrictFloat, StrictInt]] = None
    unvested_quantity: Optional[Union[StrictFloat, StrictInt]] = None
    unvested_value: Optional[Union[StrictFloat, StrictInt]] = None
    user_guid: Optional[StrictStr] = None
    vested_quantity: Optional[Union[StrictFloat, StrictInt]] = None
    vested_value: Optional[Union[StrictFloat, StrictInt]] = None
    created_at: Optional[StrictStr] = None
    current_price_as_of: Optional[StrictStr] = None
    issue_date: Optional[StrictStr] = None
    vesting_start_date: Optional[StrictStr] = None
    vesting_end_date: Optional[StrictStr] = None
    put_or_call: Optional[StrictStr] = None
    holding_type: Optional[StrictStr] = None
    term_unit: Optional[StrictStr] = None
    __properties = ["account_guid", "cost_basis", "coupon_yield", "currency_code", "current_price", "daily_change", "description", "expiration", "face_value", "frequency", "guid", "market_value", "maturity_date", "percentage_change", "purchase_price", "quantity", "rate", "strike_price", "symbol", "term", "today_ugl_amount", "today_ugl_percentage", "total_ugl_amount", "total_ugl_percentage", "unvested_quantity", "unvested_value", "user_guid", "vested_quantity", "vested_value", "created_at", "current_price_as_of", "issue_date", "vesting_start_date", "vesting_end_date", "put_or_call", "holding_type", "term_unit"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvestmentHoldingResponse:
        """Create an instance of InvestmentHoldingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if account_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.account_guid is None and "account_guid" in self.__fields_set__:
            _dict['account_guid'] = None

        # set to None if cost_basis (nullable) is None
        # and __fields_set__ contains the field
        if self.cost_basis is None and "cost_basis" in self.__fields_set__:
            _dict['cost_basis'] = None

        # set to None if coupon_yield (nullable) is None
        # and __fields_set__ contains the field
        if self.coupon_yield is None and "coupon_yield" in self.__fields_set__:
            _dict['coupon_yield'] = None

        # set to None if currency_code (nullable) is None
        # and __fields_set__ contains the field
        if self.currency_code is None and "currency_code" in self.__fields_set__:
            _dict['currency_code'] = None

        # set to None if current_price (nullable) is None
        # and __fields_set__ contains the field
        if self.current_price is None and "current_price" in self.__fields_set__:
            _dict['current_price'] = None

        # set to None if daily_change (nullable) is None
        # and __fields_set__ contains the field
        if self.daily_change is None and "daily_change" in self.__fields_set__:
            _dict['daily_change'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if expiration (nullable) is None
        # and __fields_set__ contains the field
        if self.expiration is None and "expiration" in self.__fields_set__:
            _dict['expiration'] = None

        # set to None if face_value (nullable) is None
        # and __fields_set__ contains the field
        if self.face_value is None and "face_value" in self.__fields_set__:
            _dict['face_value'] = None

        # set to None if frequency (nullable) is None
        # and __fields_set__ contains the field
        if self.frequency is None and "frequency" in self.__fields_set__:
            _dict['frequency'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if market_value (nullable) is None
        # and __fields_set__ contains the field
        if self.market_value is None and "market_value" in self.__fields_set__:
            _dict['market_value'] = None

        # set to None if maturity_date (nullable) is None
        # and __fields_set__ contains the field
        if self.maturity_date is None and "maturity_date" in self.__fields_set__:
            _dict['maturity_date'] = None

        # set to None if percentage_change (nullable) is None
        # and __fields_set__ contains the field
        if self.percentage_change is None and "percentage_change" in self.__fields_set__:
            _dict['percentage_change'] = None

        # set to None if purchase_price (nullable) is None
        # and __fields_set__ contains the field
        if self.purchase_price is None and "purchase_price" in self.__fields_set__:
            _dict['purchase_price'] = None

        # set to None if quantity (nullable) is None
        # and __fields_set__ contains the field
        if self.quantity is None and "quantity" in self.__fields_set__:
            _dict['quantity'] = None

        # set to None if rate (nullable) is None
        # and __fields_set__ contains the field
        if self.rate is None and "rate" in self.__fields_set__:
            _dict['rate'] = None

        # set to None if strike_price (nullable) is None
        # and __fields_set__ contains the field
        if self.strike_price is None and "strike_price" in self.__fields_set__:
            _dict['strike_price'] = None

        # set to None if symbol (nullable) is None
        # and __fields_set__ contains the field
        if self.symbol is None and "symbol" in self.__fields_set__:
            _dict['symbol'] = None

        # set to None if term (nullable) is None
        # and __fields_set__ contains the field
        if self.term is None and "term" in self.__fields_set__:
            _dict['term'] = None

        # set to None if today_ugl_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.today_ugl_amount is None and "today_ugl_amount" in self.__fields_set__:
            _dict['today_ugl_amount'] = None

        # set to None if today_ugl_percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.today_ugl_percentage is None and "today_ugl_percentage" in self.__fields_set__:
            _dict['today_ugl_percentage'] = None

        # set to None if total_ugl_amount (nullable) is None
        # and __fields_set__ contains the field
        if self.total_ugl_amount is None and "total_ugl_amount" in self.__fields_set__:
            _dict['total_ugl_amount'] = None

        # set to None if total_ugl_percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.total_ugl_percentage is None and "total_ugl_percentage" in self.__fields_set__:
            _dict['total_ugl_percentage'] = None

        # set to None if unvested_quantity (nullable) is None
        # and __fields_set__ contains the field
        if self.unvested_quantity is None and "unvested_quantity" in self.__fields_set__:
            _dict['unvested_quantity'] = None

        # set to None if unvested_value (nullable) is None
        # and __fields_set__ contains the field
        if self.unvested_value is None and "unvested_value" in self.__fields_set__:
            _dict['unvested_value'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        # set to None if vested_quantity (nullable) is None
        # and __fields_set__ contains the field
        if self.vested_quantity is None and "vested_quantity" in self.__fields_set__:
            _dict['vested_quantity'] = None

        # set to None if vested_value (nullable) is None
        # and __fields_set__ contains the field
        if self.vested_value is None and "vested_value" in self.__fields_set__:
            _dict['vested_value'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if current_price_as_of (nullable) is None
        # and __fields_set__ contains the field
        if self.current_price_as_of is None and "current_price_as_of" in self.__fields_set__:
            _dict['current_price_as_of'] = None

        # set to None if issue_date (nullable) is None
        # and __fields_set__ contains the field
        if self.issue_date is None and "issue_date" in self.__fields_set__:
            _dict['issue_date'] = None

        # set to None if vesting_start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.vesting_start_date is None and "vesting_start_date" in self.__fields_set__:
            _dict['vesting_start_date'] = None

        # set to None if vesting_end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.vesting_end_date is None and "vesting_end_date" in self.__fields_set__:
            _dict['vesting_end_date'] = None

        # set to None if put_or_call (nullable) is None
        # and __fields_set__ contains the field
        if self.put_or_call is None and "put_or_call" in self.__fields_set__:
            _dict['put_or_call'] = None

        # set to None if holding_type (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_type is None and "holding_type" in self.__fields_set__:
            _dict['holding_type'] = None

        # set to None if term_unit (nullable) is None
        # and __fields_set__ contains the field
        if self.term_unit is None and "term_unit" in self.__fields_set__:
            _dict['term_unit'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvestmentHoldingResponse:
        """Create an instance of InvestmentHoldingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvestmentHoldingResponse.parse_obj(obj)

        _obj = InvestmentHoldingResponse.parse_obj({
            "account_guid": obj.get("account_guid"),
            "cost_basis": obj.get("cost_basis"),
            "coupon_yield": obj.get("coupon_yield"),
            "currency_code": obj.get("currency_code"),
            "current_price": obj.get("current_price"),
            "daily_change": obj.get("daily_change"),
            "description": obj.get("description"),
            "expiration": obj.get("expiration"),
            "face_value": obj.get("face_value"),
            "frequency": obj.get("frequency"),
            "guid": obj.get("guid"),
            "market_value": obj.get("market_value"),
            "maturity_date": obj.get("maturity_date"),
            "percentage_change": obj.get("percentage_change"),
            "purchase_price": obj.get("purchase_price"),
            "quantity": obj.get("quantity"),
            "rate": obj.get("rate"),
            "strike_price": obj.get("strike_price"),
            "symbol": obj.get("symbol"),
            "term": obj.get("term"),
            "today_ugl_amount": obj.get("today_ugl_amount"),
            "today_ugl_percentage": obj.get("today_ugl_percentage"),
            "total_ugl_amount": obj.get("total_ugl_amount"),
            "total_ugl_percentage": obj.get("total_ugl_percentage"),
            "unvested_quantity": obj.get("unvested_quantity"),
            "unvested_value": obj.get("unvested_value"),
            "user_guid": obj.get("user_guid"),
            "vested_quantity": obj.get("vested_quantity"),
            "vested_value": obj.get("vested_value"),
            "created_at": obj.get("created_at"),
            "current_price_as_of": obj.get("current_price_as_of"),
            "issue_date": obj.get("issue_date"),
            "vesting_start_date": obj.get("vesting_start_date"),
            "vesting_end_date": obj.get("vesting_end_date"),
            "put_or_call": obj.get("put_or_call"),
            "holding_type": obj.get("holding_type"),
            "term_unit": obj.get("term_unit")
        })
        return _obj


