# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel

class PaymentAccount(BaseModel):
    """
    PaymentAccount
    """
    account_name: Optional[Any] = None
    account_number: Optional[Any] = None
    account_type: Optional[Any] = None
    available_balance: Optional[Any] = None
    balance: Optional[Any] = None
    created_at: Optional[Any] = None
    routing_number: Optional[Any] = None
    transit_number: Optional[Any] = None
    updated_at: Optional[Any] = None
    __properties = ["account_name", "account_number", "account_type", "available_balance", "balance", "created_at", "routing_number", "transit_number", "updated_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaymentAccount:
        """Create an instance of PaymentAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if account_name (nullable) is None
        # and __fields_set__ contains the field
        if self.account_name is None and "account_name" in self.__fields_set__:
            _dict['account_name'] = None

        # set to None if account_number (nullable) is None
        # and __fields_set__ contains the field
        if self.account_number is None and "account_number" in self.__fields_set__:
            _dict['account_number'] = None

        # set to None if account_type (nullable) is None
        # and __fields_set__ contains the field
        if self.account_type is None and "account_type" in self.__fields_set__:
            _dict['account_type'] = None

        # set to None if available_balance (nullable) is None
        # and __fields_set__ contains the field
        if self.available_balance is None and "available_balance" in self.__fields_set__:
            _dict['available_balance'] = None

        # set to None if balance (nullable) is None
        # and __fields_set__ contains the field
        if self.balance is None and "balance" in self.__fields_set__:
            _dict['balance'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if routing_number (nullable) is None
        # and __fields_set__ contains the field
        if self.routing_number is None and "routing_number" in self.__fields_set__:
            _dict['routing_number'] = None

        # set to None if transit_number (nullable) is None
        # and __fields_set__ contains the field
        if self.transit_number is None and "transit_number" in self.__fields_set__:
            _dict['transit_number'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentAccount:
        """Create an instance of PaymentAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaymentAccount.parse_obj(obj)

        _obj = PaymentAccount.parse_obj({
            "account_name": obj.get("account_name"),
            "account_number": obj.get("account_number"),
            "account_type": obj.get("account_type"),
            "available_balance": obj.get("available_balance"),
            "balance": obj.get("balance"),
            "created_at": obj.get("created_at"),
            "routing_number": obj.get("routing_number"),
            "transit_number": obj.get("transit_number"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


