# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from mx_platform_python.models.account_create_request_body import AccountCreateRequestBody
from mx_platform_python.models.account_numbers_response_body import AccountNumbersResponseBody
from mx_platform_python.models.account_owners_response_body import AccountOwnersResponseBody
from mx_platform_python.models.account_response_body import AccountResponseBody
from mx_platform_python.models.account_update_request_body import AccountUpdateRequestBody
from mx_platform_python.models.accounts_response_body import AccountsResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AccountsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_manual_account(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_create_request_body : Annotated[AccountCreateRequestBody, Field(..., description="Manual account object to be created.")], **kwargs) -> AccountResponseBody:  # noqa: E501
        """Create manual account  # noqa: E501

        This endpoint can only be used to create manual accounts. Creating a manual account will automatically create it under the Manual Institution member. Since a manual account has no credentials tied to the member, the account will never aggregate or include data from a data feed..  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_account(user_guid, account_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_create_request_body: Manual account object to be created. (required)
        :type account_create_request_body: AccountCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_manual_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_manual_account_with_http_info(user_guid, account_create_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_manual_account_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_create_request_body : Annotated[AccountCreateRequestBody, Field(..., description="Manual account object to be created.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create manual account  # noqa: E501

        This endpoint can only be used to create manual accounts. Creating a manual account will automatically create it under the Manual Institution member. Since a manual account has no credentials tied to the member, the account will never aggregate or include data from a data feed..  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_manual_account_with_http_info(user_guid, account_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_create_request_body: Manual account object to be created. (required)
        :type account_create_request_body: AccountCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'account_create_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_manual_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['account_create_request_body'] is not None:
            _body_params = _params['account_create_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_manual_account(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], accept : Annotated[StrictStr, Field(..., description="Specifies the media type expected in the response.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> None:  # noqa: E501
        """Delete manual account  # noqa: E501

        This endpoint deletes accounts that were manually created. The API will respond with an empty object and a status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_manual_account(account_guid, accept, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param accept: Specifies the media type expected in the response. (required)
        :type accept: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_manual_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_manual_account_with_http_info(account_guid, accept, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_manual_account_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], accept : Annotated[StrictStr, Field(..., description="Specifies the media type expected in the response.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete manual account  # noqa: E501

        This endpoint deletes accounts that were manually created. The API will respond with an empty object and a status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_manual_account_with_http_info(account_guid, accept, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param accept: Specifies the media type expected in the response. (required)
        :type accept: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'accept',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_manual_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['accept']:
            _header_params['Accept'] = _params['accept']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_numbers_by_account(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> AccountNumbersResponseBody:  # noqa: E501
        """List account numbers by account  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_account(account_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountNumbersResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_account_numbers_by_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_account_numbers_by_account_with_http_info(account_guid, user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_numbers_by_account_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List account numbers by account  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_account_with_http_info(account_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountNumbersResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_numbers_by_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountNumbersResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}/account_numbers', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_numbers_by_member(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> AccountNumbersResponseBody:  # noqa: E501
        """List account numbers by member  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_member(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountNumbersResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_account_numbers_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_account_numbers_by_member_with_http_info(member_guid, user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_numbers_by_member_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List account numbers by member  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_member_with_http_info(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountNumbersResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_numbers_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountNumbersResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/account_numbers', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_owners_by_member(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> AccountOwnersResponseBody:  # noqa: E501
        """List account owners by member  # noqa: E501

        This endpoint returns an array with information about every account associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_owners_by_member(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountOwnersResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_account_owners_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_account_owners_by_member_with_http_info(member_guid, user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_owners_by_member_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List account owners by member  # noqa: E501

        This endpoint returns an array with information about every account associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_owners_by_member_with_http_info(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountOwnersResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_owners_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountOwnersResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/account_owners', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_member_accounts(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], member_is_managed_by_user : Annotated[Optional[StrictBool], Field(description="List only accounts whose member is managed by the user.")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> AccountsResponseBody:  # noqa: E501
        """List accounts by member  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_member_accounts(user_guid, member_guid, member_is_managed_by_user, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param member_is_managed_by_user: List only accounts whose member is managed by the user.
        :type member_is_managed_by_user: bool
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_member_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_member_accounts_with_http_info(user_guid, member_guid, member_is_managed_by_user, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_member_accounts_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], member_is_managed_by_user : Annotated[Optional[StrictBool], Field(description="List only accounts whose member is managed by the user.")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List accounts by member  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_member_accounts_with_http_info(user_guid, member_guid, member_is_managed_by_user, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param member_is_managed_by_user: List only accounts whose member is managed by the user.
        :type member_is_managed_by_user: bool
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'member_guid',
            'member_is_managed_by_user',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_member_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']


        # process the query parameters
        _query_params = []
        if _params.get('member_is_managed_by_user') is not None:  # noqa: E501
            _query_params.append(('member_is_managed_by_user', _params['member_is_managed_by_user']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_user_accounts(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, member_is_managed_by_user : Annotated[Optional[StrictBool], Field(description="List only accounts whose member is managed by the user.")] = None, is_manual : Annotated[Optional[StrictBool], Field(description="List only accounts that were manually created.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, **kwargs) -> AccountsResponseBody:  # noqa: E501
        """List accounts  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `user`.  :::warning This request will not return the full account number. It may return the last four digits of the account number if that information has been provided during aggregation. If you need the full account number, please refer to [List account numbers by member](/api-reference/platform-api/reference/list-account-numbers-by-member/) or [List account numbers by account](/api-reference/platform-api/reference/list-account-numbers-by-account/). :::   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_user_accounts(user_guid, page, member_is_managed_by_user, is_manual, records_per_page, use_case, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param member_is_managed_by_user: List only accounts whose member is managed by the user.
        :type member_is_managed_by_user: bool
        :param is_manual: List only accounts that were manually created.
        :type is_manual: bool
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_user_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_user_accounts_with_http_info(user_guid, page, member_is_managed_by_user, is_manual, records_per_page, use_case, **kwargs)  # noqa: E501

    @validate_arguments
    def list_user_accounts_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, member_is_managed_by_user : Annotated[Optional[StrictBool], Field(description="List only accounts whose member is managed by the user.")] = None, is_manual : Annotated[Optional[StrictBool], Field(description="List only accounts that were manually created.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List accounts  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `user`.  :::warning This request will not return the full account number. It may return the last four digits of the account number if that information has been provided during aggregation. If you need the full account number, please refer to [List account numbers by member](/api-reference/platform-api/reference/list-account-numbers-by-member/) or [List account numbers by account](/api-reference/platform-api/reference/list-account-numbers-by-account/). :::   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_user_accounts_with_http_info(user_guid, page, member_is_managed_by_user, is_manual, records_per_page, use_case, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param member_is_managed_by_user: List only accounts whose member is managed by the user.
        :type member_is_managed_by_user: bool
        :param is_manual: List only accounts that were manually created.
        :type is_manual: bool
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param use_case: The use case associated with the member. Valid values are `PFM` and `MONEY_MOVEMENT`. For example, you can append either `?use_case=PFM` or `?use_case=MONEY_MOVEMENT`.
        :type use_case: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'page',
            'member_is_managed_by_user',
            'is_manual',
            'records_per_page',
            'use_case'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_user_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('member_is_managed_by_user') is not None:  # noqa: E501
            _query_params.append(('member_is_managed_by_user', _params['member_is_managed_by_user']))

        if _params.get('is_manual') is not None:  # noqa: E501
            _query_params.append(('is_manual', _params['is_manual']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('use_case', _params['use_case']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_account(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> AccountResponseBody:  # noqa: E501
        """Read account  # noqa: E501

        This endpoint returns the specified `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_account_with_http_info(account_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def read_account_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read account  # noqa: E501

        This endpoint returns the specified `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account_with_http_info(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_account_by_member(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> AccountResponseBody:  # noqa: E501
        """Read account by member  # noqa: E501

        This endpoint allows you to read the attributes of an `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account_by_member(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_account_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_account_by_member_with_http_info(account_guid, member_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def read_account_by_member_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read account by member  # noqa: E501

        This endpoint allows you to read the attributes of an `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account_by_member_with_http_info(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'member_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_account_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/accounts/{account_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_account_by_member(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_update_request_body : AccountUpdateRequestBody, **kwargs) -> AccountResponseBody:  # noqa: E501
        """Update account by member  # noqa: E501

        This endpoint allows you to update certain attributes of an `account` resource, including manual accounts. For manual accounts, you can update every field listed. For aggregated accounts, you can only update `is_business`, `is_hidden` and `metadata`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_by_member(account_guid, member_guid, user_guid, account_update_request_body, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_update_request_body: (required)
        :type account_update_request_body: AccountUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_account_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_account_by_member_with_http_info(account_guid, member_guid, user_guid, account_update_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_account_by_member_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for an `account`.")], member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], account_update_request_body : AccountUpdateRequestBody, **kwargs) -> ApiResponse:  # noqa: E501
        """Update account by member  # noqa: E501

        This endpoint allows you to update certain attributes of an `account` resource, including manual accounts. For manual accounts, you can update every field listed. For aggregated accounts, you can only update `is_business`, `is_hidden` and `metadata`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_by_member_with_http_info(account_guid, member_guid, user_guid, account_update_request_body, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for an `account`. (required)
        :type account_guid: str
        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param account_update_request_body: (required)
        :type account_update_request_body: AccountUpdateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'member_guid',
            'user_guid',
            'account_update_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['account_update_request_body'] is not None:
            _body_params = _params['account_update_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/accounts/{account_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
