# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional, Union

from mx_platform_python.models.member_response_body import MemberResponseBody
from mx_platform_python.models.statement_response_body import StatementResponseBody
from mx_platform_python.models.statements_response_body import StatementsResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StatementsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def download_statement_pdf(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], statement_guid : Annotated[StrictStr, Field(..., description="The unique id for a `statement`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> bytearray:  # noqa: E501
        """Download statement pdf  # noqa: E501

        Use this endpoint to download a specified statement PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_statement_pdf(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param statement_guid: The unique id for a `statement`. (required)
        :type statement_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the download_statement_pdf_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.download_statement_pdf_with_http_info(member_guid, statement_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def download_statement_pdf_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], statement_guid : Annotated[StrictStr, Field(..., description="The unique id for a `statement`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Download statement pdf  # noqa: E501

        Use this endpoint to download a specified statement PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_statement_pdf_with_http_info(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param statement_guid: The unique id for a `statement`. (required)
        :type statement_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'statement_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_statement_pdf" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['statement_guid']:
            _path_params['statement_guid'] = _params['statement_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+pdf'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/statements/{statement_guid}.pdf', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def fetch_statements(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> MemberResponseBody:  # noqa: E501
        """Fetch statements  # noqa: E501

        Use this endpoint to fetch the statements associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_statements(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MemberResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the fetch_statements_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.fetch_statements_with_http_info(member_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def fetch_statements_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch statements  # noqa: E501

        Use this endpoint to fetch the statements associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_statements_with_http_info(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MemberResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_statements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '202': "MemberResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/fetch_statements', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_statements_by_member(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> StatementsResponseBody:  # noqa: E501
        """List statements by member  # noqa: E501

        Use this endpoint to get an array of available statements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_statements_by_member(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatementsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_statements_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_statements_by_member_with_http_info(member_guid, user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_statements_by_member_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List statements by member  # noqa: E501

        Use this endpoint to get an array of available statements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_statements_by_member_with_http_info(member_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StatementsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_statements_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "StatementsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/statements', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_statement_by_member(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], statement_guid : Annotated[StrictStr, Field(..., description="The unique id for a `statement`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> StatementResponseBody:  # noqa: E501
        """Read statement by member  # noqa: E501

        Use this endpoint to read a JSON representation of the statement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_statement_by_member(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param statement_guid: The unique id for a `statement`. (required)
        :type statement_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatementResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_statement_by_member_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_statement_by_member_with_http_info(member_guid, statement_guid, user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def read_statement_by_member_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], statement_guid : Annotated[StrictStr, Field(..., description="The unique id for a `statement`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read statement by member  # noqa: E501

        Use this endpoint to read a JSON representation of the statement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_statement_by_member_with_http_info(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param statement_guid: The unique id for a `statement`. (required)
        :type statement_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StatementResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'statement_guid',
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_statement_by_member" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['statement_guid']:
            _path_params['statement_guid'] = _params['statement_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "StatementResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/statements/{statement_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
