# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class BudgetCreateRequest(BaseModel):
    """
    BudgetCreateRequest
    """
    category_guid: StrictStr = Field(..., description="Unique identifier of the category.")
    parent_guid: StrictStr = Field(..., description="Unique identifier of the parent budget. This is only required when creating a budget on a sub-category.")
    amount: Optional[StrictInt] = Field(None, description="Amount of the budget.")
    metadata: Optional[StrictStr] = Field(None, description="Additional information a partner can store on the budget.")
    skip_webhook: Optional[StrictBool] = Field(None, description="When set to true, this parameter will prevent a webhook from being triggered by the request.")
    __properties = ["category_guid", "parent_guid", "amount", "metadata", "skip_webhook"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BudgetCreateRequest:
        """Create an instance of BudgetCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BudgetCreateRequest:
        """Create an instance of BudgetCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BudgetCreateRequest.parse_obj(obj)

        _obj = BudgetCreateRequest.parse_obj({
            "category_guid": obj.get("category_guid"),
            "parent_guid": obj.get("parent_guid"),
            "amount": obj.get("amount"),
            "metadata": obj.get("metadata"),
            "skip_webhook": obj.get("skip_webhook")
        })
        return _obj


