# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictStr, conlist
from mx_platform_python.models.image_option_response import ImageOptionResponse
from mx_platform_python.models.option_response import OptionResponse

class ChallengeResponse(BaseModel):
    """
    ChallengeResponse
    """
    field_name: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    image_data: Optional[StrictStr] = None
    image_options: Optional[conlist(ImageOptionResponse)] = None
    label: Optional[StrictStr] = None
    options: Optional[conlist(OptionResponse)] = None
    type: Optional[StrictStr] = None
    __properties = ["field_name", "guid", "image_data", "image_options", "label", "options", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChallengeResponse:
        """Create an instance of ChallengeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in image_options (list)
        _items = []
        if self.image_options:
            for _item in self.image_options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['image_options'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item in self.options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['options'] = _items
        # set to None if field_name (nullable) is None
        # and __fields_set__ contains the field
        if self.field_name is None and "field_name" in self.__fields_set__:
            _dict['field_name'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if image_data (nullable) is None
        # and __fields_set__ contains the field
        if self.image_data is None and "image_data" in self.__fields_set__:
            _dict['image_data'] = None

        # set to None if label (nullable) is None
        # and __fields_set__ contains the field
        if self.label is None and "label" in self.__fields_set__:
            _dict['label'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChallengeResponse:
        """Create an instance of ChallengeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChallengeResponse.parse_obj(obj)

        _obj = ChallengeResponse.parse_obj({
            "field_name": obj.get("field_name"),
            "guid": obj.get("guid"),
            "image_data": obj.get("image_data"),
            "image_options": [ImageOptionResponse.from_dict(_item) for _item in obj.get("image_options")] if obj.get("image_options") is not None else None,
            "label": obj.get("label"),
            "options": [OptionResponse.from_dict(_item) for _item in obj.get("options")] if obj.get("options") is not None else None,
            "type": obj.get("type")
        })
        return _obj


