# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr

class MerchantLocationResponse(BaseModel):
    """
    MerchantLocationResponse
    """
    city: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    latitude: Optional[Union[StrictFloat, StrictInt]] = None
    longitude: Optional[Union[StrictFloat, StrictInt]] = None
    merchant_guid: Optional[StrictStr] = None
    phone_number: Optional[StrictStr] = None
    postal_code: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    street_address: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    __properties = ["city", "country", "created_at", "guid", "latitude", "longitude", "merchant_guid", "phone_number", "postal_code", "state", "street_address", "updated_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MerchantLocationResponse:
        """Create an instance of MerchantLocationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if city (nullable) is None
        # and __fields_set__ contains the field
        if self.city is None and "city" in self.__fields_set__:
            _dict['city'] = None

        # set to None if country (nullable) is None
        # and __fields_set__ contains the field
        if self.country is None and "country" in self.__fields_set__:
            _dict['country'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if latitude (nullable) is None
        # and __fields_set__ contains the field
        if self.latitude is None and "latitude" in self.__fields_set__:
            _dict['latitude'] = None

        # set to None if longitude (nullable) is None
        # and __fields_set__ contains the field
        if self.longitude is None and "longitude" in self.__fields_set__:
            _dict['longitude'] = None

        # set to None if merchant_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.merchant_guid is None and "merchant_guid" in self.__fields_set__:
            _dict['merchant_guid'] = None

        # set to None if phone_number (nullable) is None
        # and __fields_set__ contains the field
        if self.phone_number is None and "phone_number" in self.__fields_set__:
            _dict['phone_number'] = None

        # set to None if postal_code (nullable) is None
        # and __fields_set__ contains the field
        if self.postal_code is None and "postal_code" in self.__fields_set__:
            _dict['postal_code'] = None

        # set to None if state (nullable) is None
        # and __fields_set__ contains the field
        if self.state is None and "state" in self.__fields_set__:
            _dict['state'] = None

        # set to None if street_address (nullable) is None
        # and __fields_set__ contains the field
        if self.street_address is None and "street_address" in self.__fields_set__:
            _dict['street_address'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MerchantLocationResponse:
        """Create an instance of MerchantLocationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MerchantLocationResponse.parse_obj(obj)

        _obj = MerchantLocationResponse.parse_obj({
            "city": obj.get("city"),
            "country": obj.get("country"),
            "created_at": obj.get("created_at"),
            "guid": obj.get("guid"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "merchant_guid": obj.get("merchant_guid"),
            "phone_number": obj.get("phone_number"),
            "postal_code": obj.get("postal_code"),
            "state": obj.get("state"),
            "street_address": obj.get("street_address"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


