# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class MicrodepositElements(BaseModel):
    """
    MicrodepositElements
    """
    account_name: Optional[StrictStr] = None
    account_number: StrictStr = Field(...)
    account_type: StrictStr = Field(...)
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    routing_number: StrictStr = Field(...)
    __properties = ["account_name", "account_number", "account_type", "email", "first_name", "last_name", "routing_number"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MicrodepositElements:
        """Create an instance of MicrodepositElements from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MicrodepositElements:
        """Create an instance of MicrodepositElements from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MicrodepositElements.parse_obj(obj)

        _obj = MicrodepositElements.parse_obj({
            "account_name": obj.get("account_name"),
            "account_number": obj.get("account_number"),
            "account_type": obj.get("account_type"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "routing_number": obj.get("routing_number")
        })
        return _obj


