# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel

class NotificationResponse(BaseModel):
    """
    NotificationResponse
    """
    guid: Optional[Any] = None
    content: Optional[Any] = None
    deep_link_guid: Optional[Any] = None
    delivered_at: Optional[Any] = None
    entity_guid: Optional[Any] = None
    has_been_delivered: Optional[Any] = None
    has_been_viewed: Optional[Any] = None
    notification_type: Optional[Any] = None
    subject: Optional[Any] = None
    channel: Optional[Any] = None
    __properties = ["guid", "content", "deep_link_guid", "delivered_at", "entity_guid", "has_been_delivered", "has_been_viewed", "notification_type", "subject", "channel"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationResponse:
        """Create an instance of NotificationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if content (nullable) is None
        # and __fields_set__ contains the field
        if self.content is None and "content" in self.__fields_set__:
            _dict['content'] = None

        # set to None if deep_link_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.deep_link_guid is None and "deep_link_guid" in self.__fields_set__:
            _dict['deep_link_guid'] = None

        # set to None if delivered_at (nullable) is None
        # and __fields_set__ contains the field
        if self.delivered_at is None and "delivered_at" in self.__fields_set__:
            _dict['delivered_at'] = None

        # set to None if entity_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_guid is None and "entity_guid" in self.__fields_set__:
            _dict['entity_guid'] = None

        # set to None if has_been_delivered (nullable) is None
        # and __fields_set__ contains the field
        if self.has_been_delivered is None and "has_been_delivered" in self.__fields_set__:
            _dict['has_been_delivered'] = None

        # set to None if has_been_viewed (nullable) is None
        # and __fields_set__ contains the field
        if self.has_been_viewed is None and "has_been_viewed" in self.__fields_set__:
            _dict['has_been_viewed'] = None

        # set to None if notification_type (nullable) is None
        # and __fields_set__ contains the field
        if self.notification_type is None and "notification_type" in self.__fields_set__:
            _dict['notification_type'] = None

        # set to None if subject (nullable) is None
        # and __fields_set__ contains the field
        if self.subject is None and "subject" in self.__fields_set__:
            _dict['subject'] = None

        # set to None if channel (nullable) is None
        # and __fields_set__ contains the field
        if self.channel is None and "channel" in self.__fields_set__:
            _dict['channel'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationResponse:
        """Create an instance of NotificationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NotificationResponse.parse_obj(obj)

        _obj = NotificationResponse.parse_obj({
            "guid": obj.get("guid"),
            "content": obj.get("content"),
            "deep_link_guid": obj.get("deep_link_guid"),
            "delivered_at": obj.get("delivered_at"),
            "entity_guid": obj.get("entity_guid"),
            "has_been_delivered": obj.get("has_been_delivered"),
            "has_been_viewed": obj.get("has_been_viewed"),
            "notification_type": obj.get("notification_type"),
            "subject": obj.get("subject"),
            "channel": obj.get("channel")
        })
        return _obj


