# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, StrictStr

class ProcessorOwnerBodyAccountOwnersInner(BaseModel):
    """
    ProcessorOwnerBodyAccountOwnersInner
    """
    account_guid: Optional[StrictStr] = None
    member_guid: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    guid: Optional[Any] = None
    owner_name: Optional[Any] = None
    address: Optional[Any] = None
    city: Optional[Any] = None
    state: Optional[Any] = None
    postal_code: Optional[Any] = None
    country: Optional[Any] = None
    email: Optional[Any] = None
    phone: Optional[Any] = None
    __properties = ["account_guid", "member_guid", "user_guid", "guid", "owner_name", "address", "city", "state", "postal_code", "country", "email", "phone"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProcessorOwnerBodyAccountOwnersInner:
        """Create an instance of ProcessorOwnerBodyAccountOwnersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if owner_name (nullable) is None
        # and __fields_set__ contains the field
        if self.owner_name is None and "owner_name" in self.__fields_set__:
            _dict['owner_name'] = None

        # set to None if address (nullable) is None
        # and __fields_set__ contains the field
        if self.address is None and "address" in self.__fields_set__:
            _dict['address'] = None

        # set to None if city (nullable) is None
        # and __fields_set__ contains the field
        if self.city is None and "city" in self.__fields_set__:
            _dict['city'] = None

        # set to None if state (nullable) is None
        # and __fields_set__ contains the field
        if self.state is None and "state" in self.__fields_set__:
            _dict['state'] = None

        # set to None if postal_code (nullable) is None
        # and __fields_set__ contains the field
        if self.postal_code is None and "postal_code" in self.__fields_set__:
            _dict['postal_code'] = None

        # set to None if country (nullable) is None
        # and __fields_set__ contains the field
        if self.country is None and "country" in self.__fields_set__:
            _dict['country'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if phone (nullable) is None
        # and __fields_set__ contains the field
        if self.phone is None and "phone" in self.__fields_set__:
            _dict['phone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProcessorOwnerBodyAccountOwnersInner:
        """Create an instance of ProcessorOwnerBodyAccountOwnersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProcessorOwnerBodyAccountOwnersInner.parse_obj(obj)

        _obj = ProcessorOwnerBodyAccountOwnersInner.parse_obj({
            "account_guid": obj.get("account_guid"),
            "member_guid": obj.get("member_guid"),
            "user_guid": obj.get("user_guid"),
            "guid": obj.get("guid"),
            "owner_name": obj.get("owner_name"),
            "address": obj.get("address"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "postal_code": obj.get("postal_code"),
            "country": obj.get("country"),
            "email": obj.get("email"),
            "phone": obj.get("phone")
        })
        return _obj


