# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr, validator

class RepeatingTransactionResponse(BaseModel):
    """
    RepeatingTransactionResponse
    """
    account_guid: Optional[StrictStr] = None
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    description: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    member_guid: Optional[StrictStr] = None
    merchant_guid: Optional[StrictStr] = None
    last_posted_date: Optional[StrictStr] = None
    predicted_occurs_on: Optional[StrictStr] = None
    recurrence_type: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    repeating_transaction_type: Optional[StrictStr] = None
    transaction_type: Optional[StrictStr] = None
    __properties = ["account_guid", "amount", "description", "guid", "member_guid", "merchant_guid", "last_posted_date", "predicted_occurs_on", "recurrence_type", "user_guid", "repeating_transaction_type", "transaction_type"]

    @validator('repeating_transaction_type')
    def repeating_transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('BILL', 'SUBSCRIPTION', 'INCOME', 'UNKNOWN'):
            raise ValueError("must be one of enum values ('BILL', 'SUBSCRIPTION', 'INCOME', 'UNKNOWN')")
        return value

    @validator('transaction_type')
    def transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('DEBIT', 'CREDIT'):
            raise ValueError("must be one of enum values ('DEBIT', 'CREDIT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RepeatingTransactionResponse:
        """Create an instance of RepeatingTransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if account_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.account_guid is None and "account_guid" in self.__fields_set__:
            _dict['account_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RepeatingTransactionResponse:
        """Create an instance of RepeatingTransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RepeatingTransactionResponse.parse_obj(obj)

        _obj = RepeatingTransactionResponse.parse_obj({
            "account_guid": obj.get("account_guid"),
            "amount": obj.get("amount"),
            "description": obj.get("description"),
            "guid": obj.get("guid"),
            "member_guid": obj.get("member_guid"),
            "merchant_guid": obj.get("merchant_guid"),
            "last_posted_date": obj.get("last_posted_date"),
            "predicted_occurs_on": obj.get("predicted_occurs_on"),
            "recurrence_type": obj.get("recurrence_type"),
            "user_guid": obj.get("user_guid"),
            "repeating_transaction_type": obj.get("repeating_transaction_type"),
            "transaction_type": obj.get("transaction_type")
        })
        return _obj


