# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictInt, StrictStr

class RewardElements(BaseModel):
    """
    RewardElements
    """
    balance_type: Optional[StrictStr] = None
    balance: Optional[StrictInt] = None
    created_at: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    expires_on: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    unit_type: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    __properties = ["balance_type", "balance", "created_at", "description", "expires_on", "guid", "unit_type", "updated_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RewardElements:
        """Create an instance of RewardElements from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RewardElements:
        """Create an instance of RewardElements from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RewardElements.parse_obj(obj)

        _obj = RewardElements.parse_obj({
            "balance_type": obj.get("balance_type"),
            "balance": obj.get("balance"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "expires_on": obj.get("expires_on"),
            "guid": obj.get("guid"),
            "unit_type": obj.get("unit_type"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


