# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class TransactionCreateRequest(BaseModel):
    """
    TransactionCreateRequest
    """
    amount: Union[StrictFloat, StrictInt] = Field(...)
    var_date: StrictStr = Field(..., alias="date")
    description: StrictStr = Field(...)
    type: StrictStr = Field(..., description="The type of transaction, which must be CREDIT or DEBIT. See Transaction Fields for more information.")
    category_guid: Optional[StrictStr] = Field(None, description="Unique identifier of the category.")
    currency_code: Optional[StrictStr] = None
    has_been_viewed: Optional[StrictBool] = None
    is_hidden: Optional[StrictBool] = None
    is_international: Optional[StrictBool] = None
    memo: Optional[StrictStr] = None
    metadata: Optional[StrictStr] = None
    skip_webhook: Optional[StrictBool] = Field(None, description="When set to true, this parameter will prevent a webhook from being triggered by the request.")
    __properties = ["amount", "date", "description", "type", "category_guid", "currency_code", "has_been_viewed", "is_hidden", "is_international", "memo", "metadata", "skip_webhook"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionCreateRequest:
        """Create an instance of TransactionCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionCreateRequest:
        """Create an instance of TransactionCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionCreateRequest.parse_obj(obj)

        _obj = TransactionCreateRequest.parse_obj({
            "amount": obj.get("amount"),
            "var_date": obj.get("date"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "category_guid": obj.get("category_guid"),
            "currency_code": obj.get("currency_code"),
            "has_been_viewed": obj.get("has_been_viewed"),
            "is_hidden": obj.get("is_hidden"),
            "is_international": obj.get("is_international"),
            "memo": obj.get("memo"),
            "metadata": obj.get("metadata"),
            "skip_webhook": obj.get("skip_webhook")
        })
        return _obj


