# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, validator

class WidgetRequest(BaseModel):
    """
    WidgetRequest
    """
    client_redirect_url: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines the redirect destination at the end of OAuth when used with `is_mobile_webview: true` or `oauth_referral_source: 'APP'`. ")
    color_scheme: Optional[StrictStr] = Field(None, description="This option can be passed to any `widget_type` but will not affect [legacy PFM widgets](products/experience/pfm/legacy-widget-overviews/). Load the widget with the specified `color_scheme`; options are `light`, `browser` (respects user's browser setting), and `dark`. Defaults to `light`.")
    connections_use_case_filter: Optional[StrictBool] = Field(None, description="To use this parameter, you must also set `use_cases` in the same request. If `connections_use_case_filter` is set to `true`, the Connections Widget will only show connections (members) with the `use_cases` you set in the same request. For some examples, see [Filter Connections](/products/experience/pfm/widget-overviews/connections-widget#example-1).")
    current_institution_code: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. Load the widget into the credential view for the specified institution. ")
    current_institution_guid: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. Load the widget into the credential view for the specified institution. ")
    current_member_guid: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. Load the widget into a specific member that contains an error or requires multifactor authentication. The widget will determine the best view to load based on the member's current state. `current_member_guid` takes precedence over `current_institution_code` and `current_institution_guid`. ")
    disable_background_agg: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines whether background aggregation is enabled or disabled for the member created by the Connect Widget. Defaults to `false` in `aggregation` mode and `true` in `verification` mode. A global default for all members can be set by reaching out to MX. ")
    disable_institution_search: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines whether the institution search is displayed within the Connect Widget. This option must be used with `current_institution_code`, `current_instituion_guid`, or `current_member_guid`. When set to `true`, the institution search feature will be disabled and end users will not be able to navigate to it. Defaults to `false`. If you set `disable_institution_search` to `true`, you must also listen for the [backToSearch event](/connect/guides/handling-events/#back-to-search) to intercept the user from navigating back to search during the flow. Don't listen for any Primary Action postMessages when you disable search.  All buttons that will take a user to the search institution page are still displayed in the Connect Widget experience and your user can still select them. This may trigger during several steps in the Connect Widget flow, such as Connected, MDV/Microdeposits Verified, Login Error, and Credentials/OAuth (back button). ")
    enable_app2app: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, the widget will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions. ")
    include_identity: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines whether an account owner identification (AOI, previously called identity verification) is run in addition to the process specified by the `mode`. Defaults to `false`. This can be set in either `aggregation` or `verification` mode. The AOI runs after the primary process is complete. ")
    include_transactions: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines whether transaction data are retrieved. Defaults to `true` in aggregation mode and `false` in verification mode. This can be set in either `aggregation` or `verification` mode. This option does not affect future foreground or background aggregations. ")
    insight_guid: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `pulse_widget`. Set this to the insight guid you want to appear at the top of the insights feed. ")
    iso_country_code: Optional[conlist(StrictStr)] = Field(None, description="An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico). ")
    is_mobile_webview: Optional[StrictBool] = Field(None, description="This option is for all `widget_type`s. This configures the widget to render in a mobile WebView. JavaScript event postMessages are replaced with URL updates. ")
    microwidget_instance_id: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `micro_pulse_carousel_widget`. Set this to a unique value for each instance of the Micro Widget. This lets us collect unique data for each instance of the widget. ")
    mode: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. `mode` is the most important option for the Connect Widget. This determines what kind of process Connect will run, which affects how you should set many other options. Defaults to `aggregation`. `aggregation` mode retrieves account and transaction data; in other words, this runs a standard aggregation. `verification` mode retrieves account numbers and routing/transit numbers; in other words, it runs an Instant Account Verification (IAV). By default, verification mode does not retrieve transaction data; this default can be modified with secondary options. By default, background aggregation is disabled for all members created in verification mode; this default can be modified with secondary options. ")
    oauth_referral_source: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This determines how MX will respond to the result of an OAuth flow. When set to `APP`, MX will redirect to the URI specified in the `ui_message_webview_url_scheme`. When set to `BROWSER`, MX will send a postMessage but not redirect. If `is_mobile_webview` is `true`, this defaults to `APP`. If false, it defaults to `BROWSER`. ")
    ui_message_version: Optional[StrictInt] = Field(None, description="This option is for all `widget_type`s. This determines which version of postMessage events are triggered. Defaults to 4. All new implementations must use version 4. Prior versions are deprecated. ")
    ui_message_webview_url_scheme: Optional[StrictStr] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. This is a client-defined scheme used in OAuth redirects in WebViews; also used in URL updates when these replace postMessages in WebViews. Defaults to `mx`. ")
    update_credentials: Optional[StrictBool] = Field(None, description="Only use this option if the `widget_type` is set to `connect_widget`. Load the widget into a view that allows them to update the current member. Optionally used with `current_member_guid`. This option should be used sparingly. The best practice is to use `current_member_guid` and let the widget resolve the issue. ")
    use_cases: Optional[conlist(StrictStr)] = Field(None, description="The use case that will be associated with any members created through the widget. Valid values are `PFM` and/or `MONEY_MOVEMENT`. This is **required** if you've met with MX, opted in to using this field, and are requesting a widget with a `widget_type` of `connect_widget` or `connections_widget`.")
    widget_type: StrictStr = Field(..., description="This determines which widget URL you'll receive.  See [Widget Types](/api-reference/platform-api/reference/widget-types) for a list of potential values. Additional request parameters may only apply to some widget types. ")
    __properties = ["client_redirect_url", "color_scheme", "connections_use_case_filter", "current_institution_code", "current_institution_guid", "current_member_guid", "disable_background_agg", "disable_institution_search", "enable_app2app", "include_identity", "include_transactions", "insight_guid", "iso_country_code", "is_mobile_webview", "microwidget_instance_id", "mode", "oauth_referral_source", "ui_message_version", "ui_message_webview_url_scheme", "update_credentials", "use_cases", "widget_type"]

    @validator('use_cases')
    def use_cases_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('MONEY_MOVEMENT', 'PFM'):
                raise ValueError("each list item must be one of ('MONEY_MOVEMENT', 'PFM')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WidgetRequest:
        """Create an instance of WidgetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if insight_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.insight_guid is None and "insight_guid" in self.__fields_set__:
            _dict['insight_guid'] = None

        # set to None if microwidget_instance_id (nullable) is None
        # and __fields_set__ contains the field
        if self.microwidget_instance_id is None and "microwidget_instance_id" in self.__fields_set__:
            _dict['microwidget_instance_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WidgetRequest:
        """Create an instance of WidgetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WidgetRequest.parse_obj(obj)

        _obj = WidgetRequest.parse_obj({
            "client_redirect_url": obj.get("client_redirect_url"),
            "color_scheme": obj.get("color_scheme"),
            "connections_use_case_filter": obj.get("connections_use_case_filter"),
            "current_institution_code": obj.get("current_institution_code"),
            "current_institution_guid": obj.get("current_institution_guid"),
            "current_member_guid": obj.get("current_member_guid"),
            "disable_background_agg": obj.get("disable_background_agg"),
            "disable_institution_search": obj.get("disable_institution_search"),
            "enable_app2app": obj.get("enable_app2app"),
            "include_identity": obj.get("include_identity"),
            "include_transactions": obj.get("include_transactions"),
            "insight_guid": obj.get("insight_guid"),
            "iso_country_code": obj.get("iso_country_code"),
            "is_mobile_webview": obj.get("is_mobile_webview"),
            "microwidget_instance_id": obj.get("microwidget_instance_id"),
            "mode": obj.get("mode"),
            "oauth_referral_source": obj.get("oauth_referral_source"),
            "ui_message_version": obj.get("ui_message_version"),
            "ui_message_webview_url_scheme": obj.get("ui_message_webview_url_scheme"),
            "update_credentials": obj.get("update_credentials"),
            "use_cases": obj.get("use_cases"),
            "widget_type": obj.get("widget_type")
        })
        return _obj


