# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictBool, StrictFloat, StrictInt, StrictStr

class CreditCardProduct(BaseModel):
    """
    CreditCardProduct
    """
    annual_fee: Optional[Union[StrictFloat, StrictInt]] = None
    duration_of_introductory_rate_on_balance_transfer: Optional[StrictInt] = None
    duration_of_introductory_rate_on_purchases: Optional[StrictInt] = None
    guid: Optional[StrictStr] = None
    has_cashback_rewards: Optional[StrictBool] = None
    has_other_rewards: Optional[StrictBool] = None
    has_travel_rewards: Optional[StrictBool] = None
    has_zero_introductory_annual_fee: Optional[StrictBool] = None
    has_zero_percent_introductory_rate: Optional[StrictBool] = None
    has_zero_percent_introductory_rate_on_balance_transfer: Optional[StrictBool] = None
    is_accepting_applicants: Optional[StrictBool] = None
    is_active_credit_card_product: Optional[StrictBool] = None
    is_small_business_card: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    __properties = ["annual_fee", "duration_of_introductory_rate_on_balance_transfer", "duration_of_introductory_rate_on_purchases", "guid", "has_cashback_rewards", "has_other_rewards", "has_travel_rewards", "has_zero_introductory_annual_fee", "has_zero_percent_introductory_rate", "has_zero_percent_introductory_rate_on_balance_transfer", "is_accepting_applicants", "is_active_credit_card_product", "is_small_business_card", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreditCardProduct:
        """Create an instance of CreditCardProduct from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreditCardProduct:
        """Create an instance of CreditCardProduct from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreditCardProduct.parse_obj(obj)

        _obj = CreditCardProduct.parse_obj({
            "annual_fee": obj.get("annual_fee"),
            "duration_of_introductory_rate_on_balance_transfer": obj.get("duration_of_introductory_rate_on_balance_transfer"),
            "duration_of_introductory_rate_on_purchases": obj.get("duration_of_introductory_rate_on_purchases"),
            "guid": obj.get("guid"),
            "has_cashback_rewards": obj.get("has_cashback_rewards"),
            "has_other_rewards": obj.get("has_other_rewards"),
            "has_travel_rewards": obj.get("has_travel_rewards"),
            "has_zero_introductory_annual_fee": obj.get("has_zero_introductory_annual_fee"),
            "has_zero_percent_introductory_rate": obj.get("has_zero_percent_introductory_rate"),
            "has_zero_percent_introductory_rate_on_balance_transfer": obj.get("has_zero_percent_introductory_rate_on_balance_transfer"),
            "is_accepting_applicants": obj.get("is_accepting_applicants"),
            "is_active_credit_card_product": obj.get("is_active_credit_card_product"),
            "is_small_business_card": obj.get("is_small_business_card"),
            "name": obj.get("name")
        })
        return _obj


