# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel
from mx_platform_python.models.merchant_location_response import MerchantLocationResponse

class MerchantLocationResponseBody(BaseModel):
    """
    MerchantLocationResponseBody
    """
    merchant_location: Optional[MerchantLocationResponse] = None
    __properties = ["merchant_location"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MerchantLocationResponseBody:
        """Create an instance of MerchantLocationResponseBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of merchant_location
        if self.merchant_location:
            _dict['merchant_location'] = self.merchant_location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MerchantLocationResponseBody:
        """Create an instance of MerchantLocationResponseBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MerchantLocationResponseBody.parse_obj(obj)

        _obj = MerchantLocationResponseBody.parse_obj({
            "merchant_location": MerchantLocationResponse.from_dict(obj.get("merchant_location")) if obj.get("merchant_location") is not None else None
        })
        return _obj


