# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class SplitTransactionRequest(BaseModel):
    """
    SplitTransactionRequest
    """
    amount: Union[StrictFloat, StrictInt] = Field(..., description="Amount of money you want to re-categorize.")
    description: Optional[StrictStr] = Field(None, description="Description for the split transaction.")
    category_guid: Optional[StrictStr] = Field(None, description="Unique identifier of the category.")
    memo: Optional[StrictStr] = Field(None, description="Memo for the split transaction")
    __properties = ["amount", "description", "category_guid", "memo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SplitTransactionRequest:
        """Create an instance of SplitTransactionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SplitTransactionRequest:
        """Create an instance of SplitTransactionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SplitTransactionRequest.parse_obj(obj)

        _obj = SplitTransactionRequest.parse_obj({
            "amount": obj.get("amount"),
            "description": obj.get("description"),
            "category_guid": obj.get("category_guid"),
            "memo": obj.get("memo")
        })
        return _obj


