# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictInt, StrictStr

class SpendingPlanIterationResponse(BaseModel):
    """
    SpendingPlanIterationResponse
    """
    created_at: Optional[StrictStr] = None
    end_on: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    iteration_number: Optional[StrictInt] = None
    spending_plan_guid: Optional[StrictStr] = None
    start_on: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    __properties = ["created_at", "end_on", "guid", "iteration_number", "spending_plan_guid", "start_on", "updated_at", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SpendingPlanIterationResponse:
        """Create an instance of SpendingPlanIterationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if end_on (nullable) is None
        # and __fields_set__ contains the field
        if self.end_on is None and "end_on" in self.__fields_set__:
            _dict['end_on'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if iteration_number (nullable) is None
        # and __fields_set__ contains the field
        if self.iteration_number is None and "iteration_number" in self.__fields_set__:
            _dict['iteration_number'] = None

        # set to None if spending_plan_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.spending_plan_guid is None and "spending_plan_guid" in self.__fields_set__:
            _dict['spending_plan_guid'] = None

        # set to None if start_on (nullable) is None
        # and __fields_set__ contains the field
        if self.start_on is None and "start_on" in self.__fields_set__:
            _dict['start_on'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SpendingPlanIterationResponse:
        """Create an instance of SpendingPlanIterationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SpendingPlanIterationResponse.parse_obj(obj)

        _obj = SpendingPlanIterationResponse.parse_obj({
            "created_at": obj.get("created_at"),
            "end_on": obj.get("end_on"),
            "guid": obj.get("guid"),
            "iteration_number": obj.get("iteration_number"),
            "spending_plan_guid": obj.get("spending_plan_guid"),
            "start_on": obj.get("start_on"),
            "updated_at": obj.get("updated_at"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


