# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictInt, StrictStr, conlist

from typing import Optional

from mx_platform_python.models.credentials_response_body import CredentialsResponseBody
from mx_platform_python.models.institution_response_body import InstitutionResponseBody
from mx_platform_python.models.institutions_response_body import InstitutionsResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class InstitutionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def list_favorite_institutions(self, iso_country_code : Annotated[Optional[conlist(StrictStr)], Field(description="An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.")] = None, **kwargs) -> InstitutionsResponseBody:  # noqa: E501
        """List favorite institutions  # noqa: E501

        This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_favorite_institutions(iso_country_code, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param iso_country_code: An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).
        :type iso_country_code: List[str]
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstitutionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_favorite_institutions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_favorite_institutions_with_http_info(iso_country_code, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_favorite_institutions_with_http_info(self, iso_country_code : Annotated[Optional[conlist(StrictStr)], Field(description="An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List favorite institutions  # noqa: E501

        This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_favorite_institutions_with_http_info(iso_country_code, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param iso_country_code: An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).
        :type iso_country_code: List[str]
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstitutionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'iso_country_code',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_favorite_institutions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('iso_country_code') is not None:  # noqa: E501
            _query_params.append(('iso_country_code', _params['iso_country_code']))
            _collection_formats['iso_country_code'] = 'multi'

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InstitutionsResponseBody",
        }

        return self.api_client.call_api(
            '/institutions/favorites', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_institution_credentials(self, institution_code : Annotated[StrictStr, Field(..., description="The institution_code of the institution.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> CredentialsResponseBody:  # noqa: E501
        """List institution credentials  # noqa: E501

        Use this endpoint to see which credentials will be needed to create a member for a specific institution.  Passing an invalid `institution_code` returns a `404`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institution_credentials(institution_code, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param institution_code: The institution_code of the institution. (required)
        :type institution_code: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CredentialsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_institution_credentials_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_institution_credentials_with_http_info(institution_code, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_institution_credentials_with_http_info(self, institution_code : Annotated[StrictStr, Field(..., description="The institution_code of the institution.")], page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List institution credentials  # noqa: E501

        Use this endpoint to see which credentials will be needed to create a member for a specific institution.  Passing an invalid `institution_code` returns a `404`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institution_credentials_with_http_info(institution_code, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param institution_code: The institution_code of the institution. (required)
        :type institution_code: str
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `1000`. If the value exceeds `1000`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CredentialsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'institution_code',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_institution_credentials" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['institution_code']:
            _path_params['institution_code'] = _params['institution_code']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "CredentialsResponseBody",
        }

        return self.api_client.call_api(
            '/institutions/{institution_code}/credentials', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_institutions(self, name : Annotated[Optional[StrictStr], Field(description="This will list only institutions in which the appended string appears.")] = None, iso_country_code : Annotated[Optional[conlist(StrictStr)], Field(description="An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.")] = None, supports_account_identification : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account identification.")] = None, supports_account_statement : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account statements.")] = None, supports_account_verification : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account verification.")] = None, supports_transaction_history : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support extended transaction history.")] = None, **kwargs) -> InstitutionsResponseBody:  # noqa: E501
        """List institutions  # noqa: E501

        This endpoint returns a list of institutions based on the specified search term or parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institutions(name, iso_country_code, page, records_per_page, supports_account_identification, supports_account_statement, supports_account_verification, supports_transaction_history, async_req=True)
        >>> result = thread.get()

        :param name: This will list only institutions in which the appended string appears.
        :type name: str
        :param iso_country_code: An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).
        :type iso_country_code: List[str]
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param supports_account_identification: Filter only institutions which support account identification.
        :type supports_account_identification: bool
        :param supports_account_statement: Filter only institutions which support account statements.
        :type supports_account_statement: bool
        :param supports_account_verification: Filter only institutions which support account verification.
        :type supports_account_verification: bool
        :param supports_transaction_history: Filter only institutions which support extended transaction history.
        :type supports_transaction_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstitutionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_institutions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_institutions_with_http_info(name, iso_country_code, page, records_per_page, supports_account_identification, supports_account_statement, supports_account_verification, supports_transaction_history, **kwargs)  # noqa: E501

    @validate_arguments
    def list_institutions_with_http_info(self, name : Annotated[Optional[StrictStr], Field(description="This will list only institutions in which the appended string appears.")] = None, iso_country_code : Annotated[Optional[conlist(StrictStr)], Field(description="An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).")] = None, page : Annotated[Optional[StrictInt], Field(description="Results are paginated. Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.")] = None, supports_account_identification : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account identification.")] = None, supports_account_statement : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account statements.")] = None, supports_account_verification : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support account verification.")] = None, supports_transaction_history : Annotated[Optional[StrictBool], Field(description="Filter only institutions which support extended transaction history.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List institutions  # noqa: E501

        This endpoint returns a list of institutions based on the specified search term or parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institutions_with_http_info(name, iso_country_code, page, records_per_page, supports_account_identification, supports_account_statement, supports_account_verification, supports_transaction_history, async_req=True)
        >>> result = thread.get()

        :param name: This will list only institutions in which the appended string appears.
        :type name: str
        :param iso_country_code: An array of strings that filters institutions in the widget by the specified country code. Acceptable codes include `US`, `CA`, and `MX` (Mexico).
        :type iso_country_code: List[str]
        :param page: Results are paginated. Specify current page.
        :type page: int
        :param records_per_page: This specifies the number of records to be returned on each page. Defaults to `25`. The valid range is from `10` to `100`. If the value exceeds `100`, the default value of `25` will be used instead.
        :type records_per_page: int
        :param supports_account_identification: Filter only institutions which support account identification.
        :type supports_account_identification: bool
        :param supports_account_statement: Filter only institutions which support account statements.
        :type supports_account_statement: bool
        :param supports_account_verification: Filter only institutions which support account verification.
        :type supports_account_verification: bool
        :param supports_transaction_history: Filter only institutions which support extended transaction history.
        :type supports_transaction_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstitutionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'name',
            'iso_country_code',
            'page',
            'records_per_page',
            'supports_account_identification',
            'supports_account_statement',
            'supports_account_verification',
            'supports_transaction_history'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_institutions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('iso_country_code') is not None:  # noqa: E501
            _query_params.append(('iso_country_code', _params['iso_country_code']))
            _collection_formats['iso_country_code'] = 'multi'

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        if _params.get('supports_account_identification') is not None:  # noqa: E501
            _query_params.append(('supports_account_identification', _params['supports_account_identification']))

        if _params.get('supports_account_statement') is not None:  # noqa: E501
            _query_params.append(('supports_account_statement', _params['supports_account_statement']))

        if _params.get('supports_account_verification') is not None:  # noqa: E501
            _query_params.append(('supports_account_verification', _params['supports_account_verification']))

        if _params.get('supports_transaction_history') is not None:  # noqa: E501
            _query_params.append(('supports_transaction_history', _params['supports_transaction_history']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InstitutionsResponseBody",
        }

        return self.api_client.call_api(
            '/institutions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_institution(self, institution_code : Annotated[StrictStr, Field(..., description="The institution_code of the institution.")], **kwargs) -> InstitutionResponseBody:  # noqa: E501
        """Read institution  # noqa: E501

        This endpoint returns information about the institution specified by `institution_code`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_institution(institution_code, async_req=True)
        >>> result = thread.get()

        :param institution_code: The institution_code of the institution. (required)
        :type institution_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstitutionResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_institution_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_institution_with_http_info(institution_code, **kwargs)  # noqa: E501

    @validate_arguments
    def read_institution_with_http_info(self, institution_code : Annotated[StrictStr, Field(..., description="The institution_code of the institution.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read institution  # noqa: E501

        This endpoint returns information about the institution specified by `institution_code`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_institution_with_http_info(institution_code, async_req=True)
        >>> result = thread.get()

        :param institution_code: The institution_code of the institution. (required)
        :type institution_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstitutionResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'institution_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_institution" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['institution_code']:
            _path_params['institution_code'] = _params['institution_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InstitutionResponseBody",
        }

        return self.api_client.call_api(
            '/institutions/{institution_code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
