# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictStr

from typing import Optional

from mx_platform_python.models.connect_widget_request_body import ConnectWidgetRequestBody
from mx_platform_python.models.connect_widget_response_body import ConnectWidgetResponseBody
from mx_platform_python.models.o_auth_window_response_body import OAuthWindowResponseBody
from mx_platform_python.models.widget_request_body import WidgetRequestBody
from mx_platform_python.models.widget_response_body import WidgetResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WidgetsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def request_connect_widget_url(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], connect_widget_request_body : Annotated[ConnectWidgetRequestBody, Field(..., description="Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials)")], **kwargs) -> ConnectWidgetResponseBody:  # noqa: E501
        """(Deprecated) (Deprecated) Request connect widget URL  # noqa: E501

        This endpoint will return a URL for an embeddable version of MX Connect.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_connect_widget_url(user_guid, connect_widget_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param connect_widget_request_body: Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
        :type connect_widget_request_body: ConnectWidgetRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectWidgetResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the request_connect_widget_url_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.request_connect_widget_url_with_http_info(user_guid, connect_widget_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def request_connect_widget_url_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], connect_widget_request_body : Annotated[ConnectWidgetRequestBody, Field(..., description="Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials)")], **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) (Deprecated) Request connect widget URL  # noqa: E501

        This endpoint will return a URL for an embeddable version of MX Connect.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_connect_widget_url_with_http_info(user_guid, connect_widget_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param connect_widget_request_body: Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (required)
        :type connect_widget_request_body: ConnectWidgetRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectWidgetResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("POST /users/{user_guid}/connect_widget_url is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'user_guid',
            'connect_widget_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_connect_widget_url" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['connect_widget_request_body'] is not None:
            _body_params = _params['connect_widget_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "ConnectWidgetResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/connect_widget_url', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def request_o_auth_window_uri(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], client_redirect_url : Annotated[Optional[StrictStr], Field(description="A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with `referral_source=APP`.")] = None, enable_app2app : Annotated[Optional[StrictStr], Field(description="This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, any `oauth_window_uri` generated will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions.")] = None, referral_source : Annotated[Optional[StrictStr], Field(description="Must be either `BROWSER` or `APP` depending on the implementation. Defaults to `BROWSER`.")] = None, skip_aggregation : Annotated[Optional[StrictBool], Field(description="Setting this parameter to `true` will prevent the member from automatically aggregating after being redirected from the authorization page.")] = None, ui_message_webview_url_scheme : Annotated[Optional[StrictStr], Field(description="A scheme for routing the user back to the application state they were previously in. Only available with `referral_source=APP`.")] = None, **kwargs) -> OAuthWindowResponseBody:  # noqa: E501
        """Request oauth window uri  # noqa: E501

        This endpoint will generate an `oauth_window_uri` for the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_o_auth_window_uri(member_guid, user_guid, client_redirect_url, enable_app2app, referral_source, skip_aggregation, ui_message_webview_url_scheme, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param client_redirect_url: A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with `referral_source=APP`.
        :type client_redirect_url: str
        :param enable_app2app: This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, any `oauth_window_uri` generated will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions.
        :type enable_app2app: str
        :param referral_source: Must be either `BROWSER` or `APP` depending on the implementation. Defaults to `BROWSER`.
        :type referral_source: str
        :param skip_aggregation: Setting this parameter to `true` will prevent the member from automatically aggregating after being redirected from the authorization page.
        :type skip_aggregation: bool
        :param ui_message_webview_url_scheme: A scheme for routing the user back to the application state they were previously in. Only available with `referral_source=APP`.
        :type ui_message_webview_url_scheme: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OAuthWindowResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the request_o_auth_window_uri_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.request_o_auth_window_uri_with_http_info(member_guid, user_guid, client_redirect_url, enable_app2app, referral_source, skip_aggregation, ui_message_webview_url_scheme, **kwargs)  # noqa: E501

    @validate_arguments
    def request_o_auth_window_uri_with_http_info(self, member_guid : Annotated[StrictStr, Field(..., description="The unique id for a `member`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], client_redirect_url : Annotated[Optional[StrictStr], Field(description="A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with `referral_source=APP`.")] = None, enable_app2app : Annotated[Optional[StrictStr], Field(description="This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, any `oauth_window_uri` generated will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions.")] = None, referral_source : Annotated[Optional[StrictStr], Field(description="Must be either `BROWSER` or `APP` depending on the implementation. Defaults to `BROWSER`.")] = None, skip_aggregation : Annotated[Optional[StrictBool], Field(description="Setting this parameter to `true` will prevent the member from automatically aggregating after being redirected from the authorization page.")] = None, ui_message_webview_url_scheme : Annotated[Optional[StrictStr], Field(description="A scheme for routing the user back to the application state they were previously in. Only available with `referral_source=APP`.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Request oauth window uri  # noqa: E501

        This endpoint will generate an `oauth_window_uri` for the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_o_auth_window_uri_with_http_info(member_guid, user_guid, client_redirect_url, enable_app2app, referral_source, skip_aggregation, ui_message_webview_url_scheme, async_req=True)
        >>> result = thread.get()

        :param member_guid: The unique id for a `member`. (required)
        :type member_guid: str
        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param client_redirect_url: A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with `referral_source=APP`.
        :type client_redirect_url: str
        :param enable_app2app: This indicates whether OAuth app2app behavior is enabled for institutions that support it. Defaults to `true`. When set to `false`, any `oauth_window_uri` generated will **not** direct the end user to the institution's mobile application. This setting is not persistent. This setting currently only affects Chase institutions.
        :type enable_app2app: str
        :param referral_source: Must be either `BROWSER` or `APP` depending on the implementation. Defaults to `BROWSER`.
        :type referral_source: str
        :param skip_aggregation: Setting this parameter to `true` will prevent the member from automatically aggregating after being redirected from the authorization page.
        :type skip_aggregation: bool
        :param ui_message_webview_url_scheme: A scheme for routing the user back to the application state they were previously in. Only available with `referral_source=APP`.
        :type ui_message_webview_url_scheme: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OAuthWindowResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'member_guid',
            'user_guid',
            'client_redirect_url',
            'enable_app2app',
            'referral_source',
            'skip_aggregation',
            'ui_message_webview_url_scheme'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_o_auth_window_uri" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['member_guid']:
            _path_params['member_guid'] = _params['member_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('client_redirect_url') is not None:  # noqa: E501
            _query_params.append(('client_redirect_url', _params['client_redirect_url']))

        if _params.get('enable_app2app') is not None:  # noqa: E501
            _query_params.append(('enable_app2app', _params['enable_app2app']))

        if _params.get('referral_source') is not None:  # noqa: E501
            _query_params.append(('referral_source', _params['referral_source']))

        if _params.get('skip_aggregation') is not None:  # noqa: E501
            _query_params.append(('skip_aggregation', _params['skip_aggregation']))

        if _params.get('ui_message_webview_url_scheme') is not None:  # noqa: E501
            _query_params.append(('ui_message_webview_url_scheme', _params['ui_message_webview_url_scheme']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "OAuthWindowResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/members/{member_guid}/oauth_window_uri', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def request_widget_url(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], widget_request_body : Annotated[WidgetRequestBody, Field(..., description="The widget url configuration options.")], accept_language : Annotated[Optional[StrictStr], Field(description="The desired language of the widget.")] = None, x_callback_payload : Annotated[Optional[StrictStr], Field(description="The base64 encoded string defined in this header will be returned in the [Member](/resources/webhooks/member/) and [Member Data Updated](/resources/webhooks/member#member-data-updated) webhooks. This allows you to trace user interactions and workflows initiated externally and internally in the MX Platform. Max 1024 characters.")] = None, **kwargs) -> WidgetResponseBody:  # noqa: E501
        """Request widget URL  # noqa: E501

        Get an embeddable URL for integrating a widget into your website or app. The URL expires after ten minutes or upon first use, whichever occurs first. You'll need to obtain a new URL each time the page loads or reloads.  Include the `widget_type` in the request body to specify which widget you want to embed—the Connect Widget, a Personal Financial Management widget, or an Insights widget. Some request parameters are specific to certain widget types.  To embed the Connect Widget, set `widget_type` to `connect_widget`.  For a full list of available widget types, see [Widget Types](/api-reference/platform-api/reference/widgets#widget-types).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_widget_url(user_guid, widget_request_body, accept_language, x_callback_payload, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param widget_request_body: The widget url configuration options. (required)
        :type widget_request_body: WidgetRequestBody
        :param accept_language: The desired language of the widget.
        :type accept_language: str
        :param x_callback_payload: The base64 encoded string defined in this header will be returned in the [Member](/resources/webhooks/member/) and [Member Data Updated](/resources/webhooks/member#member-data-updated) webhooks. This allows you to trace user interactions and workflows initiated externally and internally in the MX Platform. Max 1024 characters.
        :type x_callback_payload: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WidgetResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the request_widget_url_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.request_widget_url_with_http_info(user_guid, widget_request_body, accept_language, x_callback_payload, **kwargs)  # noqa: E501

    @validate_arguments
    def request_widget_url_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for a `user`, beginning with the prefix `USR-`.")], widget_request_body : Annotated[WidgetRequestBody, Field(..., description="The widget url configuration options.")], accept_language : Annotated[Optional[StrictStr], Field(description="The desired language of the widget.")] = None, x_callback_payload : Annotated[Optional[StrictStr], Field(description="The base64 encoded string defined in this header will be returned in the [Member](/resources/webhooks/member/) and [Member Data Updated](/resources/webhooks/member#member-data-updated) webhooks. This allows you to trace user interactions and workflows initiated externally and internally in the MX Platform. Max 1024 characters.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Request widget URL  # noqa: E501

        Get an embeddable URL for integrating a widget into your website or app. The URL expires after ten minutes or upon first use, whichever occurs first. You'll need to obtain a new URL each time the page loads or reloads.  Include the `widget_type` in the request body to specify which widget you want to embed—the Connect Widget, a Personal Financial Management widget, or an Insights widget. Some request parameters are specific to certain widget types.  To embed the Connect Widget, set `widget_type` to `connect_widget`.  For a full list of available widget types, see [Widget Types](/api-reference/platform-api/reference/widgets#widget-types).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_widget_url_with_http_info(user_guid, widget_request_body, accept_language, x_callback_payload, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for a `user`, beginning with the prefix `USR-`. (required)
        :type user_guid: str
        :param widget_request_body: The widget url configuration options. (required)
        :type widget_request_body: WidgetRequestBody
        :param accept_language: The desired language of the widget.
        :type accept_language: str
        :param x_callback_payload: The base64 encoded string defined in this header will be returned in the [Member](/resources/webhooks/member/) and [Member Data Updated](/resources/webhooks/member#member-data-updated) webhooks. This allows you to trace user interactions and workflows initiated externally and internally in the MX Platform. Max 1024 characters.
        :type x_callback_payload: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WidgetResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'widget_request_body',
            'accept_language',
            'x_callback_payload'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_widget_url" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['accept_language']:
            _header_params['Accept-Language'] = _params['accept_language']

        if _params['x_callback_payload']:
            _header_params['X-CALLBACK-PAYLOAD'] = _params['x_callback_payload']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['widget_request_body'] is not None:
            _body_params = _params['widget_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "WidgetResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/widget_urls', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
