# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ACHReturnCreateRequest(BaseModel):
    """
    ACHReturnCreateRequest
    """
    account_guid: StrictStr = Field(..., description="The unique identifier for the account associated with the transaction. Defined by MX.")
    account_number_last_four: Optional[StrictStr] = Field(None, description="The last 4 digits of the account number used for the transaction by the Originating Depository Financial Institution (ODFI).")
    ach_initiated_at: Optional[StrictStr] = Field(None, description="The date and time when the transaction was initiated by the Originating Depository Financial Institution (ODFI) in ISO 8601 format without timestamp.")
    corrected_account_number: Optional[StrictStr] = Field(None, description="The account number correction reported by the RDFI. Populate only if the `resolution_code` is `NOTICE_OF_CHANGE`.")
    corrected_routing_number: Optional[StrictStr] = Field(None, description="The routing number correction reported by the RDFI. Populate only if the `resolution_code` is `NOTICE_OF_CHANGE`. Must be a valid 9-digit routing number format.")
    id: StrictStr = Field(..., description="Client-defined identifier for this specific return submission. Allows you to track and reference you requests.")
    member_guid: StrictStr = Field(..., description="The unique identifier for the member associated with the transaction. Defined by MX.")
    return_account_number: Optional[StrictStr] = Field(None, description="Incorrect account number used in the ACH transaction.")
    return_code: StrictStr = Field(..., description="The associated ACH return code and notice of change code (for example, R02, R03, R04, R05, R20, NOC). See [Return Codes](/api-reference/platform-api/reference/ach-return-fields#return-codes) for a complete list.")
    return_notes: Optional[StrictStr] = Field(None, description="Notes that you set to inform MX on internal ACH processing.")
    return_routing_number: Optional[StrictStr] = Field(None, description="Incorrect routing number used in the ACH transaction.")
    returned_at: Optional[StrictStr] = Field(None, description="The date and time when the return was reported by the Receiving Financial Depository Institution (RDFI) in ISO 8601 format without timestamp.")
    sec_code: Optional[StrictStr] = Field(None, description="The SEC code (Standard Entry Class Code)–a three-letter code describing how a payment was authorized (for example, `WEB`). See [SEC Codes](/api-reference/platform-api/reference/ach-return-fields#sec-codes) for a complete list.")
    transaction_amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The amount of the transaction.")
    transaction_amount_range: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="The transaction amount range, used for impact assessment.")
    user_guid: StrictStr = Field(..., description="MX-defined identifier for the user associated with the ACH return.")
    __properties = ["account_guid", "account_number_last_four", "ach_initiated_at", "corrected_account_number", "corrected_routing_number", "id", "member_guid", "return_account_number", "return_code", "return_notes", "return_routing_number", "returned_at", "sec_code", "transaction_amount", "transaction_amount_range", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ACHReturnCreateRequest:
        """Create an instance of ACHReturnCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ACHReturnCreateRequest:
        """Create an instance of ACHReturnCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ACHReturnCreateRequest.parse_obj(obj)

        _obj = ACHReturnCreateRequest.parse_obj({
            "account_guid": obj.get("account_guid"),
            "account_number_last_four": obj.get("account_number_last_four"),
            "ach_initiated_at": obj.get("ach_initiated_at"),
            "corrected_account_number": obj.get("corrected_account_number"),
            "corrected_routing_number": obj.get("corrected_routing_number"),
            "id": obj.get("id"),
            "member_guid": obj.get("member_guid"),
            "return_account_number": obj.get("return_account_number"),
            "return_code": obj.get("return_code"),
            "return_notes": obj.get("return_notes"),
            "return_routing_number": obj.get("return_routing_number"),
            "returned_at": obj.get("returned_at"),
            "sec_code": obj.get("sec_code"),
            "transaction_amount": obj.get("transaction_amount"),
            "transaction_amount_range": obj.get("transaction_amount_range"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


