# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  Just getting started? See our [use case guides](/use-cases/). 

    The version of the OpenAPI document: 20111101
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr, validator

class TransactionIncludesResponseAllOfRepeatingTransaction(BaseModel):
    """
    TransactionIncludesResponseAllOfRepeatingTransaction
    """
    repeating_transaction_type: Optional[StrictStr] = None
    recurrence_type: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    __properties = ["repeating_transaction_type", "recurrence_type", "guid"]

    @validator('repeating_transaction_type')
    def repeating_transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('BILL', 'SUBSCRIPTION', 'INCOME', 'UNKNOWN'):
            raise ValueError("must be one of enum values ('BILL', 'SUBSCRIPTION', 'INCOME', 'UNKNOWN')")
        return value

    @validator('recurrence_type')
    def recurrence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('EVERY_OTHER_WEEK'):
            raise ValueError("must be one of enum values ('EVERY_OTHER_WEEK')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionIncludesResponseAllOfRepeatingTransaction:
        """Create an instance of TransactionIncludesResponseAllOfRepeatingTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionIncludesResponseAllOfRepeatingTransaction:
        """Create an instance of TransactionIncludesResponseAllOfRepeatingTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionIncludesResponseAllOfRepeatingTransaction.parse_obj(obj)

        _obj = TransactionIncludesResponseAllOfRepeatingTransaction.parse_obj({
            "repeating_transaction_type": obj.get("repeating_transaction_type"),
            "recurrence_type": obj.get("recurrence_type"),
            "guid": obj.get("guid")
        })
        return _obj


