[![PyPi Version](https://img.shields.io/pypi/v/myvtkpythonlibrary.svg?style=flat-square)](https://pypi.org/project/myvtkpythonlibrary)
[![PyPI Downloads](https://static.pepy.tech/badge/myvtkpythonlibrary)](https://pepy.tech/projects/myvtkpythonlibrary)

# myVTKPythonLibrary

A collection of tools to manipulate meshes and images using `vtkpython`.

The library has notably been used in:
* [Genet, M., Lee, L. C., Nguyen, R., Haraldsson, H., Acevedo-Bolton, G., Zhang, Z., Ge, L., Ordovas, K., Kozerke, S., & Guccione, J. M. (2014). Distribution of normal human left ventricular myofiber stress at end diastole and end systole: A target for in silico design of heart failure treatments. Journal of Applied Physiology, 117, 142–152.](https://doi.org/10.1152/japplphysiol.00255.2014)
* [Genet, M., Lee, L. C., Ge, L., Acevedo-Bolton, G., Jeung, N., Martin, A. J., Cambronero, N., Boyle, A. J., Yeghiazarians, Y., Kozerke, S., & Guccione, J. M. (2015). A Novel Method for Quantifying Smooth Regional Variations in Myocardial Contractility Within an Infarcted Human Left Ventricle Based on Delay-Enhanced Magnetic Resonance Imaging. Journal of Biomechanical Engineering, 137(8).](https://doi.org/10.1115/1.4030667)
* [Genet, M., Rausch, M. K., Lee, L. C., Choy, S., Zhao, X., Kassab, G. S., Kozerke, S., Guccione, J. M., & Kuhl, E. (2015). Heterogeneous growth-induced prestrain in the heart. Journal of Biomechanics, 48(10), 2080–2089.](https://doi.org/10.1016/j.jbiomech.2015.03.012)
* [Tanaka, Y., Genet, M., Lee, L. C., Martin, A. J., Sievers, R., & Gerstenfeld, E. P. (2015). Utility of high-resolution electroanatomic mapping of the left ventricle using a multispline basket catheter in a swine model of chronic myocardial infarction. Heart Rhythm, 12(1), 144–154.](https://doi.org/10.1016/j.hrthm.2014.08.036)
* [Genet, M., Lee, L. C., Baillargeon, B., Guccione, J. M., & Kuhl, E. (2016). Modeling Pathologies of Diastolic and Systolic Heart Failure. Annals of Biomedical Engineering, 44(1), 112–127.](https://doi.org/10.1007/s10439-015-1351-2)
* [Berberoğlu, E., Stoeck, C. T., Moireau, P., Kozerke, S., & Genet, M. (2019). Validation of Finite Element Image Registration‐based Cardiac Strain Estimation from Magnetic Resonance Images. PAMM, 19(1).](https://doi.org/10.1002/pamm.201900418)
* [Berberoğlu, E., Stoeck, C. T., Moireau, P., Kozerke, S., & Genet, M. (2021). In-silico study of accuracy and precision of left-ventricular strain quantification from 3D tagged MRI. PLOS ONE, 16(11), e0258965.](https://doi.org/10.1371/journal.pone.0258965)
* [Castellanos, D. A., Škardová, K., Bhattaru, A., Berberoğlu, E., Greil, G., Tandon, A., Dillenbeck, J., Burkhardt, B., Hussain, T., Genet, M., & Chabiniok, R. (2021). Left Ventricular Torsion Obtained Using Equilibrated Warping in Patients with Repaired Tetralogy of Fallot. Pediatric Cardiology.](https://doi.org/10.1007/s00246-021-02608-y)
* [Berberoğlu, E., Stoeck, C. T., Kozerke, S., & Genet, M. (2022). Quantification of left ventricular strain and torsion by joint analysis of 3D tagging and cine MR images. Medical Image Analysis, 82, 102598.](https://doi.org/10.1016/j.media.2022.102598)
* [Patte, C., Brillet, P.-Y., Fetita, C., Gille, T., Bernaudin, J.-F., Nunes, H., Chapelle, D., & Genet, M. (2022). Estimation of regional pulmonary compliance in idiopathic pulmonary fibrosis based on personalized lung poromechanical modeling. Journal of Biomechanical Engineering.](https://doi.org/10.1115/1.4054106)
* [Laville, C., Fetita, C., Gille, T., Brillet, P.-Y., Nunes, H., Bernaudin, J.-F., & Genet, M. (2023). Comparison of optimization parametrizations for regional lung compliance estimation using personalized pulmonary poromechanical modeling. Biomechanics and Modeling in Mechanobiology.](https://doi.org/10.1007/s10237-023-01691-9)

## Installation

A working installation of [VTK](https://vtk.org) is required to run `myVTKPythonLibrary`, which is then easily installable via `pip`:
```
pip install myVTKPythonLibrary
```
