# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_plotly.ipynb.

# %% auto 0
__all__ = ['PLOTLY_KEY', 'MARKDOWN_KEY', 'get_custom_code', 'PlotlyProc']

# %% ../nbs/00_plotly.ipynb 2
from nbdev.process import Processor
import json


# %% ../nbs/00_plotly.ipynb 3
PLOTLY_KEY = 'application/vnd.plotly.v1+json'
MARKDOWN_KEY = 'text/markdown'

# %% ../nbs/00_plotly.ipynb 4
def get_custom_code(data):
    return open('../template/custom_code.html').read()

# %% ../nbs/00_plotly.ipynb 5
class PlotlyProc(Processor):
    "A processor that will do the conversion for outputs"
    has_multiple_cells = False
    def cell(self, cell):
        if 'outputs' in cell:
            output = cell['outputs']
            for k in output:
                if 'data' in k:
                    data = k['data']
                    if PLOTLY_KEY in data:
                        data[MARKDOWN_KEY] = [get_custom_code(data[PLOTLY_KEY])]
                        # data[HTML_KEY]['mimeType'] = PLOTLY_KEY
                        del data[PLOTLY_KEY]   
                        print('Plotly replaced')
