#pragma once

#define NBioAPIERROR_BASE_GENERAL               (0x0000)
#define NBioAPIERROR_BASE_DEVICE                (0x0100)
#define NBioAPIERROR_BASE_UI                    (0x0200)
#define NBioAPIERROR_BASE_NSEARCH               (0x0300)
#define NBioAPIERROR_BASE_IMGCONV               (0x0400)
#define NBioAPIERROR_BASE_INDEXSEARCH           (0x0500)

#define NBioAPIERROR_NONE                       (0)
#define NBioAPIERROR_INVALID_HANDLE             (NBioAPIERROR_BASE_GENERAL + 0x01)
#define NBioAPIERROR_INVALID_POINTER            (NBioAPIERROR_BASE_GENERAL + 0x02)
#define NBioAPIERROR_INVALID_TYPE               (NBioAPIERROR_BASE_GENERAL + 0x03)
#define NBioAPIERROR_FUNCTION_FAIL              (NBioAPIERROR_BASE_GENERAL + 0x04)
#define NBioAPIERROR_STRUCTTYPE_NOT_MATCHED     (NBioAPIERROR_BASE_GENERAL + 0x05)
#define NBioAPIERROR_ALREADY_PROCESSED          (NBioAPIERROR_BASE_GENERAL + 0x06)
#define NBioAPIERROR_EXTRACTION_OPEN_FAIL       (NBioAPIERROR_BASE_GENERAL + 0x07)
#define NBioAPIERROR_VERIFICATION_OPEN_FAIL     (NBioAPIERROR_BASE_GENERAL + 0x08)
#define NBioAPIERROR_DATA_PROCESS_FAIL          (NBioAPIERROR_BASE_GENERAL + 0x09)
#define NBioAPIERROR_MUST_BE_PROCESSED_DATA     (NBioAPIERROR_BASE_GENERAL + 0x0a)
#define NBioAPIERROR_INTERNAL_CHECKSUM_FAIL     (NBioAPIERROR_BASE_GENERAL + 0x0b)
#define NBioAPIERROR_ENCRYPTED_DATA_ERROR       (NBioAPIERROR_BASE_GENERAL + 0x0c) 
#define NBioAPIERROR_UNKNOWN_FORMAT             (NBioAPIERROR_BASE_GENERAL + 0x0d) 
#define NBioAPIERROR_UNKNOWN_VERSION            (NBioAPIERROR_BASE_GENERAL + 0x0e) 
#define NBioAPIERROR_VALIDITY_FAIL              (NBioAPIERROR_BASE_GENERAL + 0x0f) 

#define NBioAPIERROR_INIT_MAXFINGER             (NBioAPIERROR_BASE_GENERAL + 0x10) 
#define NBioAPIERROR_INIT_SAMPLESPERFINGER      (NBioAPIERROR_BASE_GENERAL + 0x11) 
#define NBioAPIERROR_INIT_ENROLLQUALITY         (NBioAPIERROR_BASE_GENERAL + 0x12) 
#define NBioAPIERROR_INIT_VERIFYQUALITY         (NBioAPIERROR_BASE_GENERAL + 0x13) 
#define NBioAPIERROR_INIT_IDENTIFYQUALITY       (NBioAPIERROR_BASE_GENERAL + 0x14) 
#define NBioAPIERROR_INIT_SECURITYLEVEL         (NBioAPIERROR_BASE_GENERAL + 0x15) 

#define NBioAPIERROR_INVALID_MINSIZE            (NBioAPIERROR_BASE_GENERAL + 0x16) 
#define NBioAPIERROR_INVALID_TEMPLATE           (NBioAPIERROR_BASE_GENERAL + 0x17)

#define NBioAPIERROR_EXPIRED_VERSION            (NBioAPIERROR_BASE_GENERAL + 0x18)
#define NBioAPIERROR_INVALID_SAMPLESPERFINGER   (NBioAPIERROR_BASE_GENERAL + 0x19)
#define NBioAPIERROR_UNKNOWN_INPUTFORMAT        (NBioAPIERROR_BASE_GENERAL + 0x1a)

#define NBioAPIERROR_INIT_ENROLLSECURITYLEVEL   (NBioAPIERROR_BASE_GENERAL + 0x1b)
#define NBioAPIERROR_INIT_NECESSARYENROLLNUM    (NBioAPIERROR_BASE_GENERAL + 0x1c)
#define NBioAPIERROR_INIT_RESERVED1             (NBioAPIERROR_BASE_GENERAL + 0x1d)
#define NBioAPIERROR_INIT_RESERVED2             (NBioAPIERROR_BASE_GENERAL + 0x1e)
#define NBioAPIERROR_INIT_RESERVED3             (NBioAPIERROR_BASE_GENERAL + 0x1f)
#define NBioAPIERROR_INIT_RESERVED4             (NBioAPIERROR_BASE_GENERAL + 0x20)
#define NBioAPIERROR_INIT_RESERVED5             (NBioAPIERROR_BASE_GENERAL + 0x21)
#define NBioAPIERROR_INIT_RESERVED6             (NBioAPIERROR_BASE_GENERAL + 0x22)
#define NBioAPIERROR_INIT_RESERVED7             (NBioAPIERROR_BASE_GENERAL + 0x23)
#define NBioAPIERROR_OUT_OF_MEMORY              (NBioAPIERROR_BASE_GENERAL + 0x24)

#define NBioAPIERROR_DEVICE_OPEN_FAIL           (NBioAPIERROR_BASE_DEVICE + 0x01)
#define NBioAPIERROR_INVALID_DEVICE_ID          (NBioAPIERROR_BASE_DEVICE + 0x02)
#define NBioAPIERROR_WRONG_DEVICE_ID            (NBioAPIERROR_BASE_DEVICE + 0x03)
#define NBioAPIERROR_DEVICE_ALREADY_OPENED      (NBioAPIERROR_BASE_DEVICE + 0x04)
#define NBioAPIERROR_DEVICE_NOT_OPENED          (NBioAPIERROR_BASE_DEVICE + 0x05)
#define NBioAPIERROR_DEVICE_BRIGHTNESS          (NBioAPIERROR_BASE_DEVICE + 0x06)
#define NBioAPIERROR_DEVICE_CONTRAST            (NBioAPIERROR_BASE_DEVICE + 0x07)
#define NBioAPIERROR_DEVICE_GAIN                (NBioAPIERROR_BASE_DEVICE + 0x08)
#define NBioAPIERROR_LOWVERSION_DRIVER          (NBioAPIERROR_BASE_DEVICE + 0x09)
#define NBioAPIERROR_DEVICE_INIT_FAIL           (NBioAPIERROR_BASE_DEVICE + 0x0a)
#define NBioAPIERROR_DEVICE_LOST_DEVICE         (NBioAPIERROR_BASE_DEVICE + 0x0b)
#define NBioAPIERROR_DEVICE_DLL_LOAD_FAIL       (NBioAPIERROR_BASE_DEVICE + 0x0c)
#define NBioAPIERROR_DEVICE_MAKE_INSTANCE_FAIL  (NBioAPIERROR_BASE_DEVICE + 0x0d)
#define NBioAPIERROR_DEVICE_DLL_GET_PROC_FAIL   (NBioAPIERROR_BASE_DEVICE + 0x0e)
#define NBioAPIERROR_DEVICE_IO_CONTROL_FAIL     (NBioAPIERROR_BASE_DEVICE + 0x0f)
#define NBioAPIERROR_DEVICE_NOT_SUPPORT         (NBioAPIERROR_BASE_DEVICE + 0x10)
#define NBioAPIERROR_DEVICE_LFD                 (NBioAPIERROR_BASE_DEVICE + 0x11)
#define NBioAPIERROR_INVALID_DEVICE_CODE        (NBioAPIERROR_BASE_DEVICE + 0x12)
#define NBioAPIERROR_DEVICE_NOT_FOUND           (NBioAPIERROR_BASE_DEVICE + 0x13)


#define NBioAPIERROR_USER_CANCEL                (NBioAPIERROR_BASE_UI + 0x01)
#define NBioAPIERROR_USER_BACK                  (NBioAPIERROR_BASE_UI + 0x02)
#define NBioAPIERROR_CAPTURE_TIMEOUT            (NBioAPIERROR_BASE_UI + 0x03)
#define NBioAPIERROR_CAPTURE_FAKE_SUSPICIOUS    (NBioAPIERROR_BASE_UI + 0x04)
#define NBioAPIERROR_ENROLL_EVENT_PLACE         (NBioAPIERROR_BASE_UI + 0x05)
#define NBioAPIERROR_ENROLL_EVENT_HOLD          (NBioAPIERROR_BASE_UI + 0x06)
#define NBioAPIERROR_ENROLL_EVENT_REMOVE        (NBioAPIERROR_BASE_UI + 0x07)
#define NBioAPIERROR_ENROLL_EVENT_PLACE_AGAIN   (NBioAPIERROR_BASE_UI + 0x08)
#define NBioAPIERROR_ENROLL_EVENT_EXTRACT       (NBioAPIERROR_BASE_UI + 0x09)
#define NBioAPIERROR_ENROLL_EVENT_MATCH_FAILED  (NBioAPIERROR_BASE_UI + 0x0a)

#define NBioAPIERROR_INIT_MAXCANDIDATE          (NBioAPIERROR_BASE_NSEARCH + 0x01)
#define NBioAPIERROR_NSEARCH_OPEN_FAIL          (NBioAPIERROR_BASE_NSEARCH + 0x02)
#define NBioAPIERROR_NSEARCH_INIT_FAIL          (NBioAPIERROR_BASE_NSEARCH + 0x03)
#define NBioAPIERROR_NSEARCH_MEM_OVERFLOW       (NBioAPIERROR_BASE_NSEARCH + 0x04)
#define NBioAPIERROR_NSEARCH_SAVE_DB            (NBioAPIERROR_BASE_NSEARCH + 0x05)
#define NBioAPIERROR_NSEARCH_LOAD_DB            (NBioAPIERROR_BASE_NSEARCH + 0x06)
#define NBioAPIERROR_NSEARCH_INVALD_TEMPLATE    (NBioAPIERROR_BASE_NSEARCH + 0x07)
#define NBioAPIERROR_NSEARCH_OVER_LIMIT         (NBioAPIERROR_BASE_NSEARCH + 0x08)
#define NBioAPIERROR_NSEARCH_IDENTIFY_FAIL      (NBioAPIERROR_BASE_NSEARCH + 0x09)
#define NBioAPIERROR_NSEARCH_LICENSE_LOAD       (NBioAPIERROR_BASE_NSEARCH + 0x0a)
#define NBioAPIERROR_NSEARCH_LICENSE_KEY        (NBioAPIERROR_BASE_NSEARCH + 0x0b)
#define NBioAPIERROR_NSEARCH_LICENSE_EXPIRED    (NBioAPIERROR_BASE_NSEARCH + 0x0c)
#define NBioAPIERROR_NSEARCH_DUPLICATED_ID      (NBioAPIERROR_BASE_NSEARCH + 0x0d)
#define NBioAPIERROR_NSEARCH_INVALID_ID         (NBioAPIERROR_BASE_NSEARCH + 0x0e)

#define NBioAPIERROR_IMGCONV_INVALID_PARAM      (NBioAPIERROR_BASE_IMGCONV + 0x01)
#define NBioAPIERROR_IMGCONV_MEMALLOC_FAIL      (NBioAPIERROR_BASE_IMGCONV + 0x02)
#define NBioAPIERROR_IMGCONV_FILEOPEN_FAIL      (NBioAPIERROR_BASE_IMGCONV + 0x03)
#define NBioAPIERROR_IMGCONV_FILEWRITE_FAIL     (NBioAPIERROR_BASE_IMGCONV + 0x04)

#define NBioAPIERROR_INIT_PRESEARCHRATE         (NBioAPIERROR_BASE_INDEXSEARCH + 0x01)
#define NBioAPIERROR_INDEXSEARCH_INIT_FAIL      (NBioAPIERROR_BASE_INDEXSEARCH + 0x02)
#define NBioAPIERROR_INDEXSEARCH_SAVE_DB        (NBioAPIERROR_BASE_INDEXSEARCH + 0x03)
#define NBioAPIERROR_INDEXSEARCH_LOAD_DB        (NBioAPIERROR_BASE_INDEXSEARCH + 0x04)
#define NBioAPIERROR_INDEXSEARCH_UNKNOWN_VER    (NBioAPIERROR_BASE_INDEXSEARCH + 0x05)
#define NBioAPIERROR_INDEXSEARCH_IDENTIFY_FAIL  (NBioAPIERROR_BASE_INDEXSEARCH + 0x06)
#define NBioAPIERROR_INDEXSEARCH_DUPLICATED_ID  (NBioAPIERROR_BASE_INDEXSEARCH + 0x07)
#define NBioAPIERROR_INDEXSEARCH_IDENTIFY_STOP  (NBioAPIERROR_BASE_INDEXSEARCH + 0x08)