# Copyright 2025 vesoft-inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Value type size
VALUE_TYPE_SIZE = 1

# Byte size for different data types
INT8_SIZE = 1
INT16_SIZE = 2
INT32_SIZE = 4
INT64_SIZE = 8
FLOAT_SIZE = 4
DOUBLE_SIZE = 8
BOOL_SIZE = 1
# Vector element size
EMBEDDING_VECTOR_DIM_SIZE = 4  # Size of vector dimension in row type (int32)
ELEMENT_NUMBER_SIZE_FOR_VECTOR_VALUE = 2
EMBEDDING_VECTOR_FLOAT_VALUE_SIZE = 4
FLOAT32_SIZE = 4  # Size of each float32 element in vector

# String size: 4 byte string value length + 4 byte prefix string
# + 4 byte chunk offset + 4 byte chunk index
STRING_SIZE = 16
CHUNK_INDEX_LENGTH_IN_STRING_HEADER = 4
CHUNK_INDEX_START_POSITION_IN_STRING_HEADER = 12
CHUNK_OFFSET_LENGTH_IN_STRING_HEADER = 4
CHUNK_OFFSET_START_POSITION_IN_STRING_HEADER = 8
STRING_VALUE_LENGTH_SIZE = 4
STRING_MAX_VALUE_LENGTH_IN_HEADER = 12

# Time related sizes
YEAR_SIZE = 2
MONTH_SIZE = 1
DAY_SIZE = 1
HOUR_SIZE = 1
MINUTE_SIZE = 1
SECOND_SIZE = 1
MICROSEC_SIZE = 4

DATE_SIZE = YEAR_SIZE + MONTH_SIZE + DAY_SIZE
DATE_TIME_SIZE = 8
ZONED_DATE_TIME_SIZE = 8
LOCAL_TIME_SIZE = 8
ZONED_TIME_SIZE = 8
DURATION_SIZE = 8

# List related sizes
LIST_HEADER_SIZE = 8
LIST_SIZE_SIZE = 4

# Record and Any sizes
RECORD_HEADER_SIZE = 8
ANY_HEADER_SIZE = 8

# Element sizes
GRAPH_ID_SIZE = 4
NODE_TYPE_ID_SIZE = 2
EDGE_TYPE_ID_SIZE = 4
NODE_ID_SIZE = 8
RANK_SIZE = 8

# Graph element sizes
GRAPH_ELEMENT_TYPE_NUM_SIZE = 4
PROPERTY_NUM_SIZE = 4

# Path related sizes
PATH_ELEMENT_NUM_SIZE = 4
PATH_META_DATA_NODE_EDGE_TYPE_INDEX = 2
PATH_HEADER_SIZE_SIZE = 4
PATH_HEADER_LENGTH_SIZE = 4
PATH_HEADER_HEAD_OFFSET_SIZE = 4
PATH_HEADER_TAIL_OFFSET_SIZE = 4

# Record field size
RECORD_FIELD_NUM_SIZE = 4

# Vector sizes
VECTOR_NODE_HEADER_SIZE = 16
VECTOR_EDGE_HEADER_SIZE = 32
VECTOR_PATH_HEADER_SIZE = 16
VECTOR_INDEX_SIZE = 4

# Time values in microseconds
MICRO_SECONDS_OF_SECOND = 1_000_000
MICRO_SECONDS_OF_MINUTE = 60 * MICRO_SECONDS_OF_SECOND
MICRO_SECONDS_OF_HOUR = 60 * MICRO_SECONDS_OF_MINUTE
MICRO_SECONDS_OF_DAY = 24 * MICRO_SECONDS_OF_HOUR

# Any value size
ELEMENT_NUMBER_SIZE_FOR_ANY_VALUE = 2
