*Generated By LLM*

# SessionPool Tests

This directory contains comprehensive tests for both `SessionPool` and `AsyncSessionPool` classes.

## Test Coverage

The test suite covers the following scenarios:

### SessionPool (Synchronous) Tests
- Basic initialization with custom configuration
- Session borrowing and returning
- Timeout behavior
- Concurrent access from multiple threads
- Connection establishment and cleanup
- Error handling and edge cases

### AsyncSessionPool (Asynchronous) Tests
- Basic initialization with custom configuration
- Session borrowing and returning with async/await
- Timeout behavior
- Concurrent access from multiple coroutines
- Connection establishment and cleanup
- Semaphore consistency
- Error handling and edge cases

### Edge Cases Covered
- Exception handling within context managers
- Empty session pools
- Zero timeout scenarios
- Resource cleanup on exceptions
- Partial failure during connection setup

## Running the Tests

### Prerequisites

Install the development dependencies:

```bash
# Using PDM
pdm install --dev

# Or install pytest and pytest-asyncio manually
pip install pytest pytest-asyncio
```

### Run All Tests

```bash
# Run all session pool tests
pytest tests/test_session_pool.py -v

# Run with asyncio event loop debugging
pytest tests/test_session_pool.py -v --asyncio-mode=auto

# Run specific test classes
pytest tests/test_session_pool.py::TestSessionPool -v
pytest tests/test_session_pool.py::TestAsyncSessionPool -v
pytest tests/test_session_pool.py::TestSessionPoolEdgeCases -v
```

### Run Tests with Coverage

```bash
# Install coverage tools
pip install pytest-cov

# Run with coverage report
pytest tests/test_session_pool.py --cov=nebulagraph_python.client._session_pool --cov-report=html
```

## Test Structure

The tests are organized into the following classes:

- **`TestSessionPool`**: Tests for synchronous session pool
- **`TestAsyncSessionPool`**: Tests for asynchronous session pool  
- **`TestSessionPoolEdgeCases`**: Tests for edge cases and error conditions

## Key Testing Patterns

### Mocking
- Connection objects are mocked to avoid actual network calls
- Session close functions are mocked to verify cleanup behavior
- Logger is mocked to test error logging

### Concurrency Testing
- Thread-based concurrency testing for `SessionPool`
- Asyncio task-based concurrency testing for `AsyncSessionPool`
- Timing-based tests to verify timeout behavior

### Error Injection
- Tests simulate authentication failures
- Tests verify proper cleanup on partial failures
- Tests ensure sessions are returned even when exceptions occur

### Configuration Testing
- Tests verify proper handling of custom configurations
- Tests cover timeout and retry interval settings
- Tests validate size and wait behavior configurations

## Notes

- Tests do not require a running NebulaGraph instance
- All external dependencies are mocked
- Tests are designed to run quickly and reliably
- Both sync and async pools are tested with similar scenarios to ensure consistency
- Configuration parameters are properly validated in initialization tests 