# README #

This library makes it easy to set up a Netsuite authorization without needing a frontend client using CLI utilities.

### Docs ###
[Netsuite API Documentation](https://docs.oracle.com/en/cloud/saas/netsuite/ns-online-help/section_158022624537.html)

## What do I need to get set up? ##
* Run `pip install netsuite-python`
* Activate your python VENV
* If using virtual environment 
  * Activate your virtual environment
  * `netsuite = python venv/bin/keap`

## QUICK START ##

### Prerequisite  Setup ###
    1. Enable Services
        * Restlets
        * Rest Web Services
        * Rest Web Services
        * Rest Web Services
    2. Create a role for the integration with the following permissions:
        * Access Token Management
        * Log in using Access Tokens	
        * Log in using OAuth 2.0 Access Tokens	
        * OAuth 2.0 Authorized Applications Management	
        * REST Web Services	
        * SuiteApp Deployment	
        * SuiteScript
        * User Access Tokens	
    3. Create an integration record 
        * Check Client Credentials ( MAchine to Machine Grant)
        * Under Scope Select 
            * Restlets
            * Rest Web Services
        * STORE THE CLIENT ID 


 ### Setup The Easy Way  ###
run ``` netsuite initialize ```
* Follow the prompts

* Docs will be located in the generated "netsuite_rest_client folder" at the rot of the project

#### Usage ####
```
# import Netsuite Package
from netsuite import Netsuite
# import the generated Client
from netsuite_rest_client import apis, rest_api_client
# instantiate the SDK
netsuite = Netsuite()
# Instantiate the generated Client
rest_client = rest_api_client.RestApiClient(netsuite)
# Instantiate the generated API endpoints using the generated client
customer_api = apis.CustomerApi(rest_client)

```

 #### Notes ####
  * Requirements
    * Sandbox requires the same setup as Prod, it DOES NOT copy over
    * An administrator for the Netsuite app to follow the steps [here](https://docs.oracle.com/en/cloud/saas/netsuite/ns-online-help/section_157771281570.html)
      * A user with the correct role
      * A role with the correct permissions
      * An Integration Record with the correct permissions (ensure default form is set correctly)
        * Client ID and Secret comes from this step, ensure they provide these
      * Certificate ID
        * A Certificate can be generated once you register the package with CLI with 'netsuite generate-certificate' 
        * Cert ID is available under Setup -> Integration -> OAuth 2.0 Client Credentials once the certificate is uploaded.

## Setup the hard way ##

## Generating x509 certificate for Netsuite ###
 * Run `netsuite generate-certificate`
   * Domain: theapiguys.com
   * Organization: TAG 
   * Department: DEV
   * City: BOSTON
   * State: MA
   * Country: US
   * Email: will@theapiguys.com
 
 * It will store the cert in a file in the root of the project under config/netsuite

## Uploading x509 certificate to Netsuite ##
* On Client's Netsuite top ribbon go to `Setup -> Integration -> OAuth 2.0 Client Credentials`
* Click `Create-New` button
    * Entity: The User created for TAG
    * ROLE: Role created for this integration
    * Application: Application Created for this integration
    * Certificate: Click "Choose A File" and upload the PUBLIC Cert (called netsuite-certificate.pem by default)
* Copy the Certificate ID

## Generate Netsuite Client ##
* Run command to generate sdk using openapi 3.0 
* method is generate_swagger_client
* visit link returned from method and download result 
* unzip the file and copy the "netsuite_client" folder from the directory into the projects root folder
## Setting up Netsuite SDK in a project ##
* Run `netsuite generate-client-config`
    * It will ask you for information obtained above: You can use all the defaults
        * Client ID
        * Netsuite Certificate ID
        * Netsuite Key File
        * Netsuite Application Name
        * Allow None
        * Use Datetime
        * Storage Class
      
    * If you want to save to file
        * Provide a valid path for netsuite-credentials.json
        * else the credentials will be echoed out
    * To confirm, check the netsuite credentials path you entered, or the default, and there should be a json file with all
      the info you entered. Verify the details.

## Getting The Access Token ##
* Run `$netsuite get-access-token`
    * Use the defaults or repeat the info used above for
        * Path to Netsuite Credentials
    * Confirm the app name to be refreshed, if single app, just use default
* That's it! You should now have a valid token to use with the Netsuite API.


## Usage ##


It is pretty simple to get started using the SDK once you have a valid token.

### Setup Netsuite ###
```
from netsuite import Netsuite
import netsuite_client
from netsuite_client.api.customer_api import CustomerApi

netsuite = Netsuite(config_file=settings.NS_CREDENTIALS_PATH)

customer_api = CustomerApi(netsuite.REST_CLIENT)

print(customer_api.customer_id_get(id=1617260))
```

## Example Usage ##
 ```
 print(ns_contact_api.contact_id_get(id=1413220))
 ```
