import base64
import os


def generate_random_string(length=32):
    return base64.urlsafe_b64encode(os.urandom(length)).rstrip(b"=").decode("utf-8")


def get_current_user_homedir() -> str:
    try:
        # this is the reliable/correct method that also works in cases
        # where e.g., process-manager like gunicorn changes the effective UID
        # but preserves the environment
        import pwd

        return pwd.getpwuid(os.getuid()).pw_dir
    except Exception:
        # fallback for (non-unix) platforms without `pwd` module
        return os.path.expanduser("~")
