from typing import Generator

import httpx

from .auth import NlAuth


class NlHttpxAuth(httpx.Auth):
    def __init__(self, *args, **kwargs):
        if len(args) == 1 and len(kwargs) == 0 and isinstance(args[0], NlAuth):
            # pass an existing NlAuth instance directly
            self.nlauth = args[0]
        else:
            # pass all arguments to NlAuth constructor and create NlAuth instance internally
            self.nlauth = NlAuth(*args, **kwargs)

    def auth_flow(
        self, request: httpx.Request
    ) -> Generator[httpx.Request, httpx.Response, None]:
        request.headers["Authorization"] = "Bearer " + self.nlauth.get_access_token()
        yield request
