# coding: utf-8

"""
    Nexus Repository Manager REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 3.20.1-01
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ComponentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_component(self, id, **kwargs):  # noqa: E501
        """Delete a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: ID of the component to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_component_with_http_info(id, **kwargs)  # noqa: E501

    def delete_component_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_component_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: ID of the component to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/components/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_component_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: ID of the component to retrieve (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ComponentXO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_component_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def get_component_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_component_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: ID of the component to retrieve (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ComponentXO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_component_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_component_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/components/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComponentXO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_components(self, repository, **kwargs):  # noqa: E501
        """List components  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_components(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str repository: Repository from which you would like to retrieve components (required)
        :param str continuation_token: A token returned by a prior request. If present, the next page of results are returned
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PageComponentXO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_components_with_http_info(repository, **kwargs)  # noqa: E501

    def get_components_with_http_info(self, repository, **kwargs):  # noqa: E501
        """List components  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_components_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str repository: Repository from which you would like to retrieve components (required)
        :param str continuation_token: A token returned by a prior request. If present, the next page of results are returned
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PageComponentXO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['repository', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_components" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repository` when calling `get_components`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'continuation_token' in local_var_params and local_var_params['continuation_token'] is not None:  # noqa: E501
            query_params.append(('continuationToken', local_var_params['continuation_token']))  # noqa: E501
        if 'repository' in local_var_params and local_var_params['repository'] is not None:  # noqa: E501
            query_params.append(('repository', local_var_params['repository']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/components', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageComponentXO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_component(self, repository, **kwargs):  # noqa: E501
        """Upload a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_component(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str repository: Name of the repository to which you would like to upload the component (required)
        :param str yum_directory: yum Directory
        :param file yum_asset: yum Asset 
        :param str yum_asset_filename: yum Asset  Filename
        :param file r_asset: r Asset 
        :param str r_asset_path_id: r Asset  Package Path
        :param file rubygems_asset: rubygems Asset 
        :param file nuget_asset: nuget Asset 
        :param str raw_directory: raw Directory
        :param file raw_asset1: raw Asset 1
        :param str raw_asset1_filename: raw Asset 1 Filename
        :param file raw_asset2: raw Asset 2
        :param str raw_asset2_filename: raw Asset 2 Filename
        :param file raw_asset3: raw Asset 3
        :param str raw_asset3_filename: raw Asset 3 Filename
        :param file pypi_asset: pypi Asset 
        :param file npm_asset: npm Asset 
        :param str maven2_group_id: maven2 Group ID
        :param str maven2_artifact_id: maven2 Artifact ID
        :param str maven2_version: maven2 Version
        :param bool maven2_generate_pom: maven2 Generate a POM file with these coordinates
        :param str maven2_packaging: maven2 Packaging
        :param file maven2_asset1: maven2 Asset 1
        :param str maven2_asset1_classifier: maven2 Asset 1 Classifier
        :param str maven2_asset1_extension: maven2 Asset 1 Extension
        :param file maven2_asset2: maven2 Asset 2
        :param str maven2_asset2_classifier: maven2 Asset 2 Classifier
        :param str maven2_asset2_extension: maven2 Asset 2 Extension
        :param file maven2_asset3: maven2 Asset 3
        :param str maven2_asset3_classifier: maven2 Asset 3 Classifier
        :param str maven2_asset3_extension: maven2 Asset 3 Extension
        :param file apt_asset: apt Asset 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_component_with_http_info(repository, **kwargs)  # noqa: E501

    def upload_component_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Upload a single component  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_component_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str repository: Name of the repository to which you would like to upload the component (required)
        :param str yum_directory: yum Directory
        :param file yum_asset: yum Asset 
        :param str yum_asset_filename: yum Asset  Filename
        :param file r_asset: r Asset 
        :param str r_asset_path_id: r Asset  Package Path
        :param file rubygems_asset: rubygems Asset 
        :param file nuget_asset: nuget Asset 
        :param str raw_directory: raw Directory
        :param file raw_asset1: raw Asset 1
        :param str raw_asset1_filename: raw Asset 1 Filename
        :param file raw_asset2: raw Asset 2
        :param str raw_asset2_filename: raw Asset 2 Filename
        :param file raw_asset3: raw Asset 3
        :param str raw_asset3_filename: raw Asset 3 Filename
        :param file pypi_asset: pypi Asset 
        :param file npm_asset: npm Asset 
        :param str maven2_group_id: maven2 Group ID
        :param str maven2_artifact_id: maven2 Artifact ID
        :param str maven2_version: maven2 Version
        :param bool maven2_generate_pom: maven2 Generate a POM file with these coordinates
        :param str maven2_packaging: maven2 Packaging
        :param file maven2_asset1: maven2 Asset 1
        :param str maven2_asset1_classifier: maven2 Asset 1 Classifier
        :param str maven2_asset1_extension: maven2 Asset 1 Extension
        :param file maven2_asset2: maven2 Asset 2
        :param str maven2_asset2_classifier: maven2 Asset 2 Classifier
        :param str maven2_asset2_extension: maven2 Asset 2 Extension
        :param file maven2_asset3: maven2 Asset 3
        :param str maven2_asset3_classifier: maven2 Asset 3 Classifier
        :param str maven2_asset3_extension: maven2 Asset 3 Extension
        :param file apt_asset: apt Asset 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['repository', 'yum_directory', 'yum_asset', 'yum_asset_filename', 'r_asset', 'r_asset_path_id', 'rubygems_asset', 'nuget_asset', 'raw_directory', 'raw_asset1', 'raw_asset1_filename', 'raw_asset2', 'raw_asset2_filename', 'raw_asset3', 'raw_asset3_filename', 'pypi_asset', 'npm_asset', 'maven2_group_id', 'maven2_artifact_id', 'maven2_version', 'maven2_generate_pom', 'maven2_packaging', 'maven2_asset1', 'maven2_asset1_classifier', 'maven2_asset1_extension', 'maven2_asset2', 'maven2_asset2_classifier', 'maven2_asset2_extension', 'maven2_asset3', 'maven2_asset3_classifier', 'maven2_asset3_extension', 'apt_asset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_component" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repository` when calling `upload_component`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repository' in local_var_params and local_var_params['repository'] is not None:  # noqa: E501
            query_params.append(('repository', local_var_params['repository']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'yum_directory' in local_var_params:
            form_params.append(('yum.directory', local_var_params['yum_directory']))  # noqa: E501
        if 'yum_asset' in local_var_params:
            local_var_files['yum.asset'] = local_var_params['yum_asset']  # noqa: E501
        if 'yum_asset_filename' in local_var_params:
            form_params.append(('yum.asset.filename', local_var_params['yum_asset_filename']))  # noqa: E501
        if 'r_asset' in local_var_params:
            local_var_files['r.asset'] = local_var_params['r_asset']  # noqa: E501
        if 'r_asset_path_id' in local_var_params:
            form_params.append(('r.asset.pathId', local_var_params['r_asset_path_id']))  # noqa: E501
        if 'rubygems_asset' in local_var_params:
            local_var_files['rubygems.asset'] = local_var_params['rubygems_asset']  # noqa: E501
        if 'nuget_asset' in local_var_params:
            local_var_files['nuget.asset'] = local_var_params['nuget_asset']  # noqa: E501
        if 'raw_directory' in local_var_params:
            form_params.append(('raw.directory', local_var_params['raw_directory']))  # noqa: E501
        if 'raw_asset1' in local_var_params:
            local_var_files['raw.asset1'] = local_var_params['raw_asset1']  # noqa: E501
        if 'raw_asset1_filename' in local_var_params:
            form_params.append(('raw.asset1.filename', local_var_params['raw_asset1_filename']))  # noqa: E501
        if 'raw_asset2' in local_var_params:
            local_var_files['raw.asset2'] = local_var_params['raw_asset2']  # noqa: E501
        if 'raw_asset2_filename' in local_var_params:
            form_params.append(('raw.asset2.filename', local_var_params['raw_asset2_filename']))  # noqa: E501
        if 'raw_asset3' in local_var_params:
            local_var_files['raw.asset3'] = local_var_params['raw_asset3']  # noqa: E501
        if 'raw_asset3_filename' in local_var_params:
            form_params.append(('raw.asset3.filename', local_var_params['raw_asset3_filename']))  # noqa: E501
        if 'pypi_asset' in local_var_params:
            local_var_files['pypi.asset'] = local_var_params['pypi_asset']  # noqa: E501
        if 'npm_asset' in local_var_params:
            local_var_files['npm.asset'] = local_var_params['npm_asset']  # noqa: E501
        if 'maven2_group_id' in local_var_params:
            form_params.append(('maven2.groupId', local_var_params['maven2_group_id']))  # noqa: E501
        if 'maven2_artifact_id' in local_var_params:
            form_params.append(('maven2.artifactId', local_var_params['maven2_artifact_id']))  # noqa: E501
        if 'maven2_version' in local_var_params:
            form_params.append(('maven2.version', local_var_params['maven2_version']))  # noqa: E501
        if 'maven2_generate_pom' in local_var_params:
            form_params.append(('maven2.generate-pom', local_var_params['maven2_generate_pom']))  # noqa: E501
        if 'maven2_packaging' in local_var_params:
            form_params.append(('maven2.packaging', local_var_params['maven2_packaging']))  # noqa: E501
        if 'maven2_asset1' in local_var_params:
            local_var_files['maven2.asset1'] = local_var_params['maven2_asset1']  # noqa: E501
        if 'maven2_asset1_classifier' in local_var_params:
            form_params.append(('maven2.asset1.classifier', local_var_params['maven2_asset1_classifier']))  # noqa: E501
        if 'maven2_asset1_extension' in local_var_params:
            form_params.append(('maven2.asset1.extension', local_var_params['maven2_asset1_extension']))  # noqa: E501
        if 'maven2_asset2' in local_var_params:
            local_var_files['maven2.asset2'] = local_var_params['maven2_asset2']  # noqa: E501
        if 'maven2_asset2_classifier' in local_var_params:
            form_params.append(('maven2.asset2.classifier', local_var_params['maven2_asset2_classifier']))  # noqa: E501
        if 'maven2_asset2_extension' in local_var_params:
            form_params.append(('maven2.asset2.extension', local_var_params['maven2_asset2_extension']))  # noqa: E501
        if 'maven2_asset3' in local_var_params:
            local_var_files['maven2.asset3'] = local_var_params['maven2_asset3']  # noqa: E501
        if 'maven2_asset3_classifier' in local_var_params:
            form_params.append(('maven2.asset3.classifier', local_var_params['maven2_asset3_classifier']))  # noqa: E501
        if 'maven2_asset3_extension' in local_var_params:
            form_params.append(('maven2.asset3.extension', local_var_params['maven2_asset3_extension']))  # noqa: E501
        if 'apt_asset' in local_var_params:
            local_var_files['apt.asset'] = local_var_params['apt_asset']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/components', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
