# openapi-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.20.1-01
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nexus_api_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nexus_api_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nexus_api_python_client
from nexus_api_python_client.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost/service/rest
configuration.host = "http://localhost/service/rest"
# Enter a context with an instance of the API client
with nexus_api_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nexus_api_python_client.BlobStoreApi(api_client)
    body = nexus_api_python_client.S3BlobStoreApiModel() # S3BlobStoreApiModel |  (optional)

    try:
        # Create an S3 blob store
        api_instance.create_blob_store(body=body)
    except ApiException as e:
        print("Exception when calling BlobStoreApi->create_blob_store: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/service/rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BlobStoreApi* | [**create_blob_store**](docs/BlobStoreApi.md#create_blob_store) | **POST** /beta/blobstores/s3 | Create an S3 blob store
*BlobStoreApi* | [**create_file_blob_store**](docs/BlobStoreApi.md#create_file_blob_store) | **POST** /beta/blobstores/file | Create a file blob store
*BlobStoreApi* | [**delete_blob_store**](docs/BlobStoreApi.md#delete_blob_store) | **DELETE** /beta/blobstores/{name} | Delete a blob store by name
*BlobStoreApi* | [**get_blob_store**](docs/BlobStoreApi.md#get_blob_store) | **GET** /beta/blobstores/s3/{name} | Fetch a S3 blob store configuration
*BlobStoreApi* | [**get_file_blob_store_configuration**](docs/BlobStoreApi.md#get_file_blob_store_configuration) | **GET** /beta/blobstores/file/{name} | Get a file blob store configuration by name
*BlobStoreApi* | [**list_blob_stores**](docs/BlobStoreApi.md#list_blob_stores) | **GET** /beta/blobstores | List the blob stores
*BlobStoreApi* | [**quota_status**](docs/BlobStoreApi.md#quota_status) | **GET** /v1/blobstores/{id}/quota-status | Get quota status for a given blob store
*BlobStoreApi* | [**update_blob_store**](docs/BlobStoreApi.md#update_blob_store) | **PUT** /beta/blobstores/s3/{name} | Update an S3 blob store configuration
*BlobStoreApi* | [**update_file_blob_store**](docs/BlobStoreApi.md#update_file_blob_store) | **PUT** /beta/blobstores/file/{name} | Update a file blob store configuration by name
*ManageIQServerConfigurationApi* | [**disable_iq**](docs/ManageIQServerConfigurationApi.md#disable_iq) | **POST** /beta/iq/disable | Disable IQ Server
*ManageIQServerConfigurationApi* | [**enable_iq**](docs/ManageIQServerConfigurationApi.md#enable_iq) | **POST** /beta/iq/enable | Enable IQ Server
*ManageIQServerConfigurationApi* | [**get_configuration**](docs/ManageIQServerConfigurationApi.md#get_configuration) | **GET** /beta/iq | Get IQ Server configuration
*ManageIQServerConfigurationApi* | [**update_configuration**](docs/ManageIQServerConfigurationApi.md#update_configuration) | **PUT** /beta/iq | Update IQ Server configuration
*ManageIQServerConfigurationApi* | [**verify_connection**](docs/ManageIQServerConfigurationApi.md#verify_connection) | **POST** /beta/iq/verify-connection | Verify IQ Server connection
*ProductLicensingApi* | [**get_license_status**](docs/ProductLicensingApi.md#get_license_status) | **GET** /beta/system/license | Get the current license status.
*ProductLicensingApi* | [**remove_license**](docs/ProductLicensingApi.md#remove_license) | **DELETE** /beta/system/license | Uninstall license if present.
*ProductLicensingApi* | [**set_license**](docs/ProductLicensingApi.md#set_license) | **POST** /beta/system/license | Upload a new license file.
*RepositoryManagementApi* | [**create_repository1**](docs/RepositoryManagementApi.md#create_repository1) | **POST** /beta/repositories/apt/hosted | 
*RepositoryManagementApi* | [**create_repository10**](docs/RepositoryManagementApi.md#create_repository10) | **POST** /beta/repositories/docker/hosted | 
*RepositoryManagementApi* | [**create_repository11**](docs/RepositoryManagementApi.md#create_repository11) | **POST** /beta/repositories/gitlfs/hosted | 
*RepositoryManagementApi* | [**create_repository2**](docs/RepositoryManagementApi.md#create_repository2) | **POST** /beta/repositories/apt/proxy | 
*RepositoryManagementApi* | [**create_repository3**](docs/RepositoryManagementApi.md#create_repository3) | **POST** /beta/repositories/go/group | 
*RepositoryManagementApi* | [**create_repository4**](docs/RepositoryManagementApi.md#create_repository4) | **POST** /beta/repositories/go/proxy | 
*RepositoryManagementApi* | [**create_repository5**](docs/RepositoryManagementApi.md#create_repository5) | **POST** /beta/repositories/bower/group | 
*RepositoryManagementApi* | [**create_repository6**](docs/RepositoryManagementApi.md#create_repository6) | **POST** /beta/repositories/bower/proxy | 
*RepositoryManagementApi* | [**create_repository7**](docs/RepositoryManagementApi.md#create_repository7) | **POST** /beta/repositories/bower/hosted | 
*RepositoryManagementApi* | [**create_repository8**](docs/RepositoryManagementApi.md#create_repository8) | **POST** /beta/repositories/docker/group | 
*RepositoryManagementApi* | [**create_repository9**](docs/RepositoryManagementApi.md#create_repository9) | **POST** /beta/repositories/docker/proxy | 
*RepositoryManagementApi* | [**delete_repository**](docs/RepositoryManagementApi.md#delete_repository) | **DELETE** /beta/repositories/{repositoryName} | Delete repository of any format
*RepositoryManagementApi* | [**disable_repository_health_check**](docs/RepositoryManagementApi.md#disable_repository_health_check) | **DELETE** /beta/repositories/{repositoryName}/health-check | Disable Repository Health Check. Proxy repositories only.
*RepositoryManagementApi* | [**enable_repository_health_check**](docs/RepositoryManagementApi.md#enable_repository_health_check) | **POST** /beta/repositories/{repositoryName}/health-check | Enable Repository Health Check. Proxy repositories only.
*RepositoryManagementApi* | [**get_repositories**](docs/RepositoryManagementApi.md#get_repositories) | **GET** /beta/repositories | List repositories
*RepositoryManagementApi* | [**invalidate_cache**](docs/RepositoryManagementApi.md#invalidate_cache) | **POST** /beta/repositories/{repositoryName}/invalidate-cache | Invalidate repository cache. Proxy or group repositories only.
*RepositoryManagementApi* | [**rebuild_index**](docs/RepositoryManagementApi.md#rebuild_index) | **POST** /beta/repositories/{repositoryName}/rebuild-index | Schedule a &#39;Repair - Rebuild repository search&#39; Task. Hosted or proxy repositories only.
*RepositoryManagementApi* | [**update_repository1**](docs/RepositoryManagementApi.md#update_repository1) | **PUT** /beta/repositories/apt/hosted/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository10**](docs/RepositoryManagementApi.md#update_repository10) | **PUT** /beta/repositories/docker/hosted/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository11**](docs/RepositoryManagementApi.md#update_repository11) | **PUT** /beta/repositories/gitlfs/hosted/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository2**](docs/RepositoryManagementApi.md#update_repository2) | **PUT** /beta/repositories/apt/proxy/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository3**](docs/RepositoryManagementApi.md#update_repository3) | **PUT** /beta/repositories/go/group/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository4**](docs/RepositoryManagementApi.md#update_repository4) | **PUT** /beta/repositories/go/proxy/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository5**](docs/RepositoryManagementApi.md#update_repository5) | **PUT** /beta/repositories/bower/group/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository6**](docs/RepositoryManagementApi.md#update_repository6) | **PUT** /beta/repositories/bower/proxy/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository7**](docs/RepositoryManagementApi.md#update_repository7) | **PUT** /beta/repositories/bower/hosted/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository8**](docs/RepositoryManagementApi.md#update_repository8) | **PUT** /beta/repositories/docker/group/{repositoryName} | 
*RepositoryManagementApi* | [**update_repository9**](docs/RepositoryManagementApi.md#update_repository9) | **PUT** /beta/repositories/docker/proxy/{repositoryName} | 
*SecurityCertificatesApi* | [**add_certificate**](docs/SecurityCertificatesApi.md#add_certificate) | **POST** /beta/security/ssl/truststore | Add a certificate to the trust store.
*SecurityCertificatesApi* | [**get_trust_store_certificates**](docs/SecurityCertificatesApi.md#get_trust_store_certificates) | **GET** /beta/security/ssl/truststore | Retrieve a list of certificates added to the trust store.
*SecurityCertificatesApi* | [**remove_certificate**](docs/SecurityCertificatesApi.md#remove_certificate) | **DELETE** /beta/security/ssl/truststore/{id} | Remove a certificate in the trust store.
*SecurityCertificatesApi* | [**retrieve_certificate**](docs/SecurityCertificatesApi.md#retrieve_certificate) | **GET** /beta/security/ssl | Helper method to retrieve certificate details from a remote system.
*SecurityManagementApi* | [**get_user_sources**](docs/SecurityManagementApi.md#get_user_sources) | **GET** /beta/security/user-sources | Retrieve a list of the available user sources.
*SecurityManagementLDAPApi* | [**change_order**](docs/SecurityManagementLDAPApi.md#change_order) | **POST** /beta/security/ldap/change-order | Change LDAP server order
*SecurityManagementLDAPApi* | [**create_ldap_server**](docs/SecurityManagementLDAPApi.md#create_ldap_server) | **POST** /beta/security/ldap | Create LDAP server
*SecurityManagementLDAPApi* | [**delete_ldap_server**](docs/SecurityManagementLDAPApi.md#delete_ldap_server) | **DELETE** /beta/security/ldap/{name} | Delete LDAP server
*SecurityManagementLDAPApi* | [**get_ldap_server**](docs/SecurityManagementLDAPApi.md#get_ldap_server) | **GET** /beta/security/ldap/{name} | Get LDAP server
*SecurityManagementLDAPApi* | [**get_ldap_servers**](docs/SecurityManagementLDAPApi.md#get_ldap_servers) | **GET** /beta/security/ldap | List LDAP servers
*SecurityManagementLDAPApi* | [**update_ldap_server**](docs/SecurityManagementLDAPApi.md#update_ldap_server) | **PUT** /beta/security/ldap/{name} | Update LDAP server
*SecurityManagementPrivilegesApi* | [**create_privilege**](docs/SecurityManagementPrivilegesApi.md#create_privilege) | **POST** /beta/security/privileges/application | Create an application type privilege.
*SecurityManagementPrivilegesApi* | [**create_privilege1**](docs/SecurityManagementPrivilegesApi.md#create_privilege1) | **POST** /beta/security/privileges/wildcard | Create a wildcard type privilege.
*SecurityManagementPrivilegesApi* | [**create_privilege2**](docs/SecurityManagementPrivilegesApi.md#create_privilege2) | **POST** /beta/security/privileges/repository-content-selector | Create a repository content selector type privilege.
*SecurityManagementPrivilegesApi* | [**create_privilege3**](docs/SecurityManagementPrivilegesApi.md#create_privilege3) | **POST** /beta/security/privileges/repository-admin | Create a repository admin type privilege.
*SecurityManagementPrivilegesApi* | [**create_privilege4**](docs/SecurityManagementPrivilegesApi.md#create_privilege4) | **POST** /beta/security/privileges/repository-view | Create a repository view type privilege.
*SecurityManagementPrivilegesApi* | [**create_privilege5**](docs/SecurityManagementPrivilegesApi.md#create_privilege5) | **POST** /beta/security/privileges/script | Create a script type privilege.
*SecurityManagementPrivilegesApi* | [**delete_privilege**](docs/SecurityManagementPrivilegesApi.md#delete_privilege) | **DELETE** /beta/security/privileges/{privilegeId} | Delete a privilege by id.
*SecurityManagementPrivilegesApi* | [**get_privilege**](docs/SecurityManagementPrivilegesApi.md#get_privilege) | **GET** /beta/security/privileges/{privilegeId} | Retrieve a privilege by id.
*SecurityManagementPrivilegesApi* | [**get_privileges**](docs/SecurityManagementPrivilegesApi.md#get_privileges) | **GET** /beta/security/privileges | Retrieve a list of privileges.
*SecurityManagementPrivilegesApi* | [**update_privilege**](docs/SecurityManagementPrivilegesApi.md#update_privilege) | **PUT** /beta/security/privileges/wildcard/{privilegeId} | Update a wildcard type privilege.
*SecurityManagementPrivilegesApi* | [**update_privilege1**](docs/SecurityManagementPrivilegesApi.md#update_privilege1) | **PUT** /beta/security/privileges/application/{privilegeId} | Update an application type privilege.
*SecurityManagementPrivilegesApi* | [**update_privilege2**](docs/SecurityManagementPrivilegesApi.md#update_privilege2) | **PUT** /beta/security/privileges/repository-view/{privilegeId} | Update a repository view type privilege.
*SecurityManagementPrivilegesApi* | [**update_privilege3**](docs/SecurityManagementPrivilegesApi.md#update_privilege3) | **PUT** /beta/security/privileges/repository-content-selector/{privilegeId} | Update a repository content selector type privilege.
*SecurityManagementPrivilegesApi* | [**update_privilege4**](docs/SecurityManagementPrivilegesApi.md#update_privilege4) | **PUT** /beta/security/privileges/repository-admin/{privilegeId} | Update a repository admin type privilege.
*SecurityManagementPrivilegesApi* | [**update_privilege5**](docs/SecurityManagementPrivilegesApi.md#update_privilege5) | **PUT** /beta/security/privileges/script/{privilegeId} | Update a script type privilege.
*SecurityManagementRealmsApi* | [**get_active_realms**](docs/SecurityManagementRealmsApi.md#get_active_realms) | **GET** /beta/security/realms/active | List the active realm IDs in order
*SecurityManagementRealmsApi* | [**get_realms**](docs/SecurityManagementRealmsApi.md#get_realms) | **GET** /beta/security/realms/available | List the available realms
*SecurityManagementRealmsApi* | [**set_active_realms**](docs/SecurityManagementRealmsApi.md#set_active_realms) | **PUT** /beta/security/realms/active | Set the active security realms in the order they should be used
*SecurityManagementRolesApi* | [**create**](docs/SecurityManagementRolesApi.md#create) | **POST** /beta/security/roles | Create role
*SecurityManagementRolesApi* | [**delete**](docs/SecurityManagementRolesApi.md#delete) | **DELETE** /beta/security/roles/{id} | Delete role
*SecurityManagementRolesApi* | [**get_role**](docs/SecurityManagementRolesApi.md#get_role) | **GET** /beta/security/roles/{id} | Get role
*SecurityManagementRolesApi* | [**get_roles**](docs/SecurityManagementRolesApi.md#get_roles) | **GET** /beta/security/roles | List roles
*SecurityManagementRolesApi* | [**update**](docs/SecurityManagementRolesApi.md#update) | **PUT** /beta/security/roles/{id} | Update role
*SecurityManagementUsersApi* | [**change_password**](docs/SecurityManagementUsersApi.md#change_password) | **PUT** /beta/security/users/{userId}/change-password | Change a user&#39;s password.
*SecurityManagementUsersApi* | [**create_user**](docs/SecurityManagementUsersApi.md#create_user) | **POST** /beta/security/users | Create a new user in the default source.
*SecurityManagementUsersApi* | [**delete_user**](docs/SecurityManagementUsersApi.md#delete_user) | **DELETE** /beta/security/users/{userId} | Delete a user.
*SecurityManagementUsersApi* | [**get_users**](docs/SecurityManagementUsersApi.md#get_users) | **GET** /beta/security/users | Retrieve a list of users. Note if the source is not &#39;default&#39; the response is limited to 100 users.
*SecurityManagementUsersApi* | [**update_user**](docs/SecurityManagementUsersApi.md#update_user) | **PUT** /beta/security/users/{userId} | Update an existing user.
*AssetsApi* | [**delete_asset**](docs/AssetsApi.md#delete_asset) | **DELETE** /v1/assets/{id} | Delete a single asset
*AssetsApi* | [**get_asset_by_id**](docs/AssetsApi.md#get_asset_by_id) | **GET** /v1/assets/{id} | Get a single asset
*AssetsApi* | [**get_assets**](docs/AssetsApi.md#get_assets) | **GET** /v1/assets | List assets
*ComponentsApi* | [**delete_component**](docs/ComponentsApi.md#delete_component) | **DELETE** /v1/components/{id} | Delete a single component
*ComponentsApi* | [**get_component_by_id**](docs/ComponentsApi.md#get_component_by_id) | **GET** /v1/components/{id} | Get a single component
*ComponentsApi* | [**get_components**](docs/ComponentsApi.md#get_components) | **GET** /v1/components | List components
*ComponentsApi* | [**upload_component**](docs/ComponentsApi.md#upload_component) | **POST** /v1/components | Upload a single component
*ContentSelectorsApi* | [**create_content_selector**](docs/ContentSelectorsApi.md#create_content_selector) | **POST** /beta/security/content-selectors | Create a new content selector
*ContentSelectorsApi* | [**delete_content_selector**](docs/ContentSelectorsApi.md#delete_content_selector) | **DELETE** /beta/security/content-selectors/{name} | Delete a content selector
*ContentSelectorsApi* | [**get_content_selector**](docs/ContentSelectorsApi.md#get_content_selector) | **GET** /beta/security/content-selectors/{name} | Get a content selector by id
*ContentSelectorsApi* | [**get_content_selectors**](docs/ContentSelectorsApi.md#get_content_selectors) | **GET** /beta/security/content-selectors | List Content Selectors
*ContentSelectorsApi* | [**update_content_selector**](docs/ContentSelectorsApi.md#update_content_selector) | **PUT** /beta/security/content-selectors/{name} | Update a content selector
*EmailApi* | [**delete_email_configuration**](docs/EmailApi.md#delete_email_configuration) | **DELETE** /beta/email | Disable and clear the email configuration
*EmailApi* | [**get_email_configuration**](docs/EmailApi.md#get_email_configuration) | **GET** /beta/email | Retrieve the current email configuration
*EmailApi* | [**set_email_configuration**](docs/EmailApi.md#set_email_configuration) | **PUT** /beta/email | Set the current email configuration
*EmailApi* | [**test_email_configuration**](docs/EmailApi.md#test_email_configuration) | **POST** /beta/email/verify | Send a test email to the email address provided in the request body
*FormatsApi* | [**get1**](docs/FormatsApi.md#get1) | **GET** /v1/formats/{format}/upload-specs | Get upload field requirements for the desired format
*FormatsApi* | [**get2**](docs/FormatsApi.md#get2) | **GET** /v1/formats/upload-specs | Get upload field requirements for each supported format
*LifecycleApi* | [**bounce**](docs/LifecycleApi.md#bounce) | **PUT** /v1/lifecycle/bounce | Bounce lifecycle phase
*LifecycleApi* | [**get_phase**](docs/LifecycleApi.md#get_phase) | **GET** /v1/lifecycle/phase | Get current lifecycle phase
*LifecycleApi* | [**set_phase**](docs/LifecycleApi.md#set_phase) | **PUT** /v1/lifecycle/phase | Move to new lifecycle phase
*ReadOnlyApi* | [**force_release**](docs/ReadOnlyApi.md#force_release) | **POST** /v1/read-only/force-release | Forcibly release read-only
*ReadOnlyApi* | [**freeze**](docs/ReadOnlyApi.md#freeze) | **POST** /v1/read-only/freeze | Enable read-only
*ReadOnlyApi* | [**get**](docs/ReadOnlyApi.md#get) | **GET** /v1/read-only | Get read-only state
*ReadOnlyApi* | [**release**](docs/ReadOnlyApi.md#release) | **POST** /v1/read-only/release | Release read-only
*RepositoriesApi* | [**get_repositories1**](docs/RepositoriesApi.md#get_repositories1) | **GET** /v1/repositories | List repositories
*RoutingRulesApi* | [**create_routing_rule**](docs/RoutingRulesApi.md#create_routing_rule) | **POST** /beta/routing-rules | Create a single routing rule
*RoutingRulesApi* | [**delete_routing_rule**](docs/RoutingRulesApi.md#delete_routing_rule) | **DELETE** /beta/routing-rules/{name} | Delete a single routing rule
*RoutingRulesApi* | [**get_routing_rule**](docs/RoutingRulesApi.md#get_routing_rule) | **GET** /beta/routing-rules/{name} | Get a single routing rule
*RoutingRulesApi* | [**get_routing_rules**](docs/RoutingRulesApi.md#get_routing_rules) | **GET** /beta/routing-rules | List routing rules
*RoutingRulesApi* | [**update_routing_rule**](docs/RoutingRulesApi.md#update_routing_rule) | **PUT** /beta/routing-rules/{name} | Update a single routing rule
*ScriptApi* | [**add**](docs/ScriptApi.md#add) | **POST** /v1/script | Add a new script
*ScriptApi* | [**browse**](docs/ScriptApi.md#browse) | **GET** /v1/script | List all stored scripts
*ScriptApi* | [**delete1**](docs/ScriptApi.md#delete1) | **DELETE** /v1/script/{name} | Delete stored script by name
*ScriptApi* | [**edit**](docs/ScriptApi.md#edit) | **PUT** /v1/script/{name} | Update stored script by name
*ScriptApi* | [**read**](docs/ScriptApi.md#read) | **GET** /v1/script/{name} | Read stored script by name
*ScriptApi* | [**run1**](docs/ScriptApi.md#run1) | **POST** /v1/script/{name}/run | Run stored script by name
*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /v1/search | Search components
*SearchApi* | [**search_and_download_assets**](docs/SearchApi.md#search_and_download_assets) | **GET** /v1/search/assets/download | Search and download asset
*SearchApi* | [**search_assets**](docs/SearchApi.md#search_assets) | **GET** /v1/search/assets | Search assets
*StatusApi* | [**get_system_status_checks**](docs/StatusApi.md#get_system_status_checks) | **GET** /v1/status/check | Health check endpoint that returns the results of the system status checks
*StatusApi* | [**is_available**](docs/StatusApi.md#is_available) | **GET** /v1/status | Health check endpoint that validates server can respond to read requests
*StatusApi* | [**is_writable**](docs/StatusApi.md#is_writable) | **GET** /v1/status/writable | Health check endpoint that validates server can respond to read and write requests
*SupportApi* | [**supportzip**](docs/SupportApi.md#supportzip) | **POST** /v1/support/supportzip | Creates and downloads a support zip
*TasksApi* | [**get_task_by_id**](docs/TasksApi.md#get_task_by_id) | **GET** /v1/tasks/{id} | Get a single task by id
*TasksApi* | [**get_tasks**](docs/TasksApi.md#get_tasks) | **GET** /v1/tasks | List tasks
*TasksApi* | [**run**](docs/TasksApi.md#run) | **POST** /v1/tasks/{id}/run | Run task
*TasksApi* | [**stop**](docs/TasksApi.md#stop) | **POST** /v1/tasks/{id}/stop | Stop task


## Documentation For Models

 - [AbstractApiRepository](docs/AbstractApiRepository.md)
 - [ApiCertificate](docs/ApiCertificate.md)
 - [ApiCreateUser](docs/ApiCreateUser.md)
 - [ApiEmailConfiguration](docs/ApiEmailConfiguration.md)
 - [ApiEmailValidation](docs/ApiEmailValidation.md)
 - [ApiLicenseDetailsXO](docs/ApiLicenseDetailsXO.md)
 - [ApiPrivilege](docs/ApiPrivilege.md)
 - [ApiPrivilegeApplicationRequest](docs/ApiPrivilegeApplicationRequest.md)
 - [ApiPrivilegeRepositoryAdminRequest](docs/ApiPrivilegeRepositoryAdminRequest.md)
 - [ApiPrivilegeRepositoryContentSelectorRequest](docs/ApiPrivilegeRepositoryContentSelectorRequest.md)
 - [ApiPrivilegeRepositoryViewRequest](docs/ApiPrivilegeRepositoryViewRequest.md)
 - [ApiPrivilegeScriptRequest](docs/ApiPrivilegeScriptRequest.md)
 - [ApiPrivilegeWildcardRequest](docs/ApiPrivilegeWildcardRequest.md)
 - [ApiUser](docs/ApiUser.md)
 - [ApiUserSource](docs/ApiUserSource.md)
 - [AptHostedRepositoriesAttributes](docs/AptHostedRepositoriesAttributes.md)
 - [AptHostedRepositoryApiRequest](docs/AptHostedRepositoryApiRequest.md)
 - [AptProxyRepositoriesAttributes](docs/AptProxyRepositoriesAttributes.md)
 - [AptProxyRepositoryApiRequest](docs/AptProxyRepositoryApiRequest.md)
 - [AptSigningRepositoriesAttributes](docs/AptSigningRepositoriesAttributes.md)
 - [AssetXO](docs/AssetXO.md)
 - [BlobStoreApiSoftQuota](docs/BlobStoreApiSoftQuota.md)
 - [BlobStoreQuotaResultXO](docs/BlobStoreQuotaResultXO.md)
 - [BowerAttributes](docs/BowerAttributes.md)
 - [BowerGroupRepositoryApiRequest](docs/BowerGroupRepositoryApiRequest.md)
 - [BowerHostedRepositoryApiRequest](docs/BowerHostedRepositoryApiRequest.md)
 - [BowerProxyRepositoryApiRequest](docs/BowerProxyRepositoryApiRequest.md)
 - [CleanupPolicyAttributes](docs/CleanupPolicyAttributes.md)
 - [ComponentXO](docs/ComponentXO.md)
 - [ContentSelectorApiCreateRequest](docs/ContentSelectorApiCreateRequest.md)
 - [ContentSelectorApiResponse](docs/ContentSelectorApiResponse.md)
 - [ContentSelectorApiUpdateRequest](docs/ContentSelectorApiUpdateRequest.md)
 - [CreateLdapServerXo](docs/CreateLdapServerXo.md)
 - [DockerAttributes](docs/DockerAttributes.md)
 - [DockerGroupRepositoryApiRequest](docs/DockerGroupRepositoryApiRequest.md)
 - [DockerHostedRepositoryApiRequest](docs/DockerHostedRepositoryApiRequest.md)
 - [DockerProxyAttributes](docs/DockerProxyAttributes.md)
 - [DockerProxyRepositoryApiRequest](docs/DockerProxyRepositoryApiRequest.md)
 - [FileBlobStoreApiCreateRequest](docs/FileBlobStoreApiCreateRequest.md)
 - [FileBlobStoreApiModel](docs/FileBlobStoreApiModel.md)
 - [FileBlobStoreApiUpdateRequest](docs/FileBlobStoreApiUpdateRequest.md)
 - [GenericBlobStoreApiResponse](docs/GenericBlobStoreApiResponse.md)
 - [GitLfsHostedRepositoryApiRequest](docs/GitLfsHostedRepositoryApiRequest.md)
 - [GolangGroupRepositoryApiRequest](docs/GolangGroupRepositoryApiRequest.md)
 - [GolangProxyRepositoryApiRequest](docs/GolangProxyRepositoryApiRequest.md)
 - [GroupAttributes](docs/GroupAttributes.md)
 - [HostedStorageAttributes](docs/HostedStorageAttributes.md)
 - [HttpClientAttributes](docs/HttpClientAttributes.md)
 - [HttpClientConnectionAttributes](docs/HttpClientConnectionAttributes.md)
 - [HttpClientConnectionAuthenticationAttributes](docs/HttpClientConnectionAuthenticationAttributes.md)
 - [IqConnectionVerificationXo](docs/IqConnectionVerificationXo.md)
 - [IqConnectionXo](docs/IqConnectionXo.md)
 - [NegativeCacheAttributes](docs/NegativeCacheAttributes.md)
 - [Page](docs/Page.md)
 - [PageAssetXO](docs/PageAssetXO.md)
 - [PageComponentXO](docs/PageComponentXO.md)
 - [PageTaskXO](docs/PageTaskXO.md)
 - [ProxyAttributes](docs/ProxyAttributes.md)
 - [ReadLdapServerXo](docs/ReadLdapServerXo.md)
 - [ReadOnlyState](docs/ReadOnlyState.md)
 - [RealmApiXO](docs/RealmApiXO.md)
 - [RepositoryXO](docs/RepositoryXO.md)
 - [Request](docs/Request.md)
 - [Result](docs/Result.md)
 - [RoleXORequest](docs/RoleXORequest.md)
 - [RoleXOResponse](docs/RoleXOResponse.md)
 - [RoutingRuleXO](docs/RoutingRuleXO.md)
 - [S3BlobStoreApiAdvancedBucketConnection](docs/S3BlobStoreApiAdvancedBucketConnection.md)
 - [S3BlobStoreApiBucket](docs/S3BlobStoreApiBucket.md)
 - [S3BlobStoreApiBucketConfiguration](docs/S3BlobStoreApiBucketConfiguration.md)
 - [S3BlobStoreApiBucketSecurity](docs/S3BlobStoreApiBucketSecurity.md)
 - [S3BlobStoreApiEncryption](docs/S3BlobStoreApiEncryption.md)
 - [S3BlobStoreApiModel](docs/S3BlobStoreApiModel.md)
 - [ScriptResultXO](docs/ScriptResultXO.md)
 - [ScriptXO](docs/ScriptXO.md)
 - [StackTraceElement](docs/StackTraceElement.md)
 - [StorageAttributes](docs/StorageAttributes.md)
 - [TaskXO](docs/TaskXO.md)
 - [Throwable](docs/Throwable.md)
 - [UpdateLdapServerXo](docs/UpdateLdapServerXo.md)
 - [UploadDefinitionXO](docs/UploadDefinitionXO.md)
 - [UploadFieldDefinitionXO](docs/UploadFieldDefinitionXO.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




