"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeJsInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
;
const supportedMachineImages = [
    ec2.AmazonLinuxImage,
];
/**
 * Create an EC2 instance with Node.js installed
 */
class NodeJsInstance extends ec2.Instance {
    constructor(scope, id, props) {
        if (!supportedMachineImages.some((image) => props.machineImage instanceof image)) {
            throw new Error('Only AMAZON_LINUX, AMAZON_LINUX_2, AMAZON_LINUX_2022, and AMAZON_LINUX_2023 are supported.');
        }
        const nodejsUserData = props.userData ?? ec2.UserData.forLinux();
        nodejsUserData.addCommands('touch ~/.bashrc', 'curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.7/install.sh | bash', 'source ~/.bashrc', 'export NVM_DIR="$HOME/.nvm"', '[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"', 'nvm install --lts', `cat <<EOF >> /home/ec2-user/.bashrc
export NVM_DIR="/.nvm"
[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
EOF`);
        const { nodeJsVersion, ...rest } = props;
        super(scope, id, { ...rest, userData: nodejsUserData });
    }
}
exports.NodeJsInstance = NodeJsInstance;
_a = JSII_RTTI_SYMBOL_1;
NodeJsInstance[_a] = { fqn: "cdk-node-ec2-instance.NodeJsInstance", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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