"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeJsInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
;
const supportedMachineImages = [
    ec2.AmazonLinuxImage,
];
/**
 * Create an EC2 instance with Node.js installed
 */
class NodeJsInstance extends ec2.Instance {
    constructor(scope, id, props) {
        if (!supportedMachineImages.some((image) => props.machineImage instanceof image)) {
            throw new Error('Only AMAZON_LINUX, AMAZON_LINUX_2, AMAZON_LINUX_2022, and AMAZON_LINUX_2023 are supported.');
        }
        const nodejsUserData = props.userData ?? ec2.UserData.forLinux();
        nodejsUserData.addCommands('touch ~/.bashrc', 'curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.7/install.sh | bash', 'source ~/.bashrc', 'export NVM_DIR="$HOME/.nvm"', '[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"', `nvm install ${props.nodeJsVersion ?? '--lts'}`, `cat <<EOF >> /home/ec2-user/.bashrc
export NVM_DIR="/.nvm"
[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
EOF`);
        const { nodeJsVersion, ...rest } = props;
        super(scope, id, { ...rest, userData: nodejsUserData });
    }
}
exports.NodeJsInstance = NodeJsInstance;
_a = JSII_RTTI_SYMBOL_1;
NodeJsInstance[_a] = { fqn: "cdk-node-ec2-instance.NodeJsInstance", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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