# Politique de sécurité

## Préambule

La présente politique a été produite en conformité du paragraphe (a) du premier alinéa de l’article 7 de la Directive sur la sécurité de l’information gouvernementale. Celle-ci fait obligation aux organismes publics d’adopter et de mettre en œuvre une politique de sécurité de l’information, de la maintenir à jour et d’en assurer l’application.

## Définitions

Actif informationnel : Tout document dont la définition correspond à celle de l’article 3 de la Loi concernant le cadre juridique des technologies de l’information (chapitre C-1.1). À titre de rappel, cette loi définit le document comme étant : « Un ensemble constitué d’information portée par un support. L’information y est délimitée et structurée, de façon tangible ou logique selon le support qui la porte et elle est intelligible sous forme de mots, de sons ou d’images. L’information peut être rendue au moyen de tout mode d’écriture, y compris d’un système de symboles transcrit sous l’une de ses formes ou en un autre système de symboles ».

Cette même loi assimile au document toute banque de données dont les éléments structurants permettent la création de documents par la délimitation et la structuration de l’information qui y est inscrite.

*Cycle de vie de l’information*: L’ensemble des étapes que franchit une information et qui vont de sa création, en passant par son enregistrement, son transfert, sa consultation, son traitement et sa transmission, jusqu’à sa conservation ou sa destruction, en conformité avec le calendrier de conservation de l’organisme public.

*Disponibilité*: Propriété d’une information d’être accessible en temps voulu et de la manière requise pour une personne autorisée.

*Intégrité*: Propriété associée à une information de ne subir aucune altération ou destruction sans autorisation et d’être conservée sur un support lui procurant stabilité et pérennité.

*Confidentialité*: Propriété d’une information de n’être accessible qu’aux personnes ou entités désignées et autorisées.

## Cadre légal et administratif

La politique de sécurité s’inscrit principalement dans un contexte régi par :
la Loi sur le ministère ;
la Charte des droits et libertés de la personne (LRQ, chapitre C-12);
le Code civil du Québec (LQ, 1991, chapitre 64);
la Politique-cadre sur la gouvernance et la gestion des ressources informationnelles des organismes publics;
la Loi sur la gouvernance et la gestion des ressources informationnelles des organismes publics et des entreprises du gouvernement (LRQ, chapitre G-1.03);
la Loi concernant le cadre juridique des technologies et l’information (LRQ, chapitre C-1.1);
la Loi sur l’accès aux documents des organismes publics et sur la protection des renseignements personnels (LRQ, chapitre A-2.1);
la Loi sur les archives (LRQ, chapitre A-21.1);
la Loi sur l’administration publique (LRQ, chapitre A-6.01);
la Loi sur la fonction publique (LRQ, chapitre F-3.1.1);
la Loi canadienne sur les droits de la personne (LRC, 1985, chapitre H-6);
le Code criminel (LRC, 1985, chapitre C-46); ü la Loi sur le droit d’auteur (LRC, 1985, chapitre C-42);
le Règlement sur la diffusion de l’information et sur la protection des renseignements personnels (chapitre A-2.1, r. 02);
la Directive sur la sécurité de l’information gouvernementale;
la Directive sur les services de certification offerts par le gouvernement du Québec pendant la phase intérimaire.

## Objectif de la politique

La présente politique a pour objectif d’affirmer l’engagement du Ministère de la Cybersécurité et du Numérique (MCN) de s’acquitter pleinement de ses obligations à l’égard de la sécurité de l’information, quels que soient son support ou son moyen de communication. Plus précisément, il s’agit d’assurer, tout au long du cycle de vie de l’information, sa disponibilité, son intégrité et sa confidentialité.

## Champ d’application

La présente politique s’adresse aux utilisateurs, c'est-à-dire à tout le personnel du MCN et des organismes publics qui consomment des services partagés, peu importe son statut. Plus précisément, toute personne physique ou morale qui, à titre d’employé, de consultant, de partenaire ou de fournisseur, utilise les actifs informationnels du ministère ou y a accès ainsi qu’à toute personne dûment autorisée à y avoir accès. L’information visée est celle que le MCN détient dans l’exercice de ses fonctions, que sa conservation soit assurée par lui-même ou par un tiers.

## Énoncés de principes généraux

### Protection de l’information

a) Le ministère adhère aux orientations et objectifs stratégiques gouvernementaux en matière de sécurité de l’information et s’engage à ce que les pratiques et les solutions retenues en la matière correspondent, dans la mesure du possible, à des façons de faire reconnues et généralement utilisées, tant à l’échelle nationale qu'à l'échelle internationale.

b) Le ministère reconnaît que les actifs informationnels qu’il détient sont essentiels à ses activités courantes et, de ce fait, qu'ils doivent faire l’objet d’une évaluation constante, d’une utilisation appropriée et d’une protection adéquate. Le niveau de protection dont les actifs informationnels doivent faire l’objet d’une évaluation constante, d’une utilisation appropriée et d’une protection adéquate.

Le niveau de protection dont les actifs informationnels doivent faire l’objet est établi en fonction de leur importance, de leur confidentialité et des risques d’accident, d’erreur et de malveillance auxquels ils sont exposés.

c) La sécurité des actifs informationnels est soutenue par une démarche d’éthique visant à assurer la régulation des conduites et la responsabilisation individuelle.

### Protection des renseignements confidentiels

Toute information confidentielle doit être préservée de toute divulgation, de tout accès ou de toute utilisation non autorisée. Sont notamment considérés comme confidentiels, au sens de la Loi sur l’accès aux documents des organismes publics et sur la protection des renseignements personnels, les renseignements personnels ainsi que tout renseignement dont la divulgation aurait des incidences, notamment sur les relations intergouvernementales, les négociations entre organismes publics, l’économie, les tiers relativement à leurs renseignements industriels, financiers, commerciaux, scientifiques ou techniques, l’administration de la justice et la sécurité publique, les décisions administratives ou politiques et la vérification.

### Sensibilisation et formation

Le ministère s’engage, sur une base régulière, à sensibiliser et à former les utilisateurs à la sécurité des actifs informationnels, aux conséquences d’une atteinte à leur sécurité ainsi qu’à leur rôle et leurs obligations en la matière.

### Droit de regard

Le ministère exerce, en conformité avec la législation et la réglementation en vigueur, un droit de regard sur tout usage de ses actifs informationnels.

### Classification de l'information

Le ministère attribue une classification des documents produits qui permet de mieux contrôler l’accès à la documentation mise à la disposition des usagers internes et externes au MCN. En ce qui concerne les accès, ça revient aux gestionnaires des services (propriétaire), qui eux, détermineront les droits d’accès accordés aux usagers sous leur responsabilité.

Une information peut être catégorisée sous trois grandes classes en respect de la Loi sur l’accès aux documents des organismes publics et sur la protection des renseignements personnels (L.R.Q., C.A-2.1) : a)

* *Publique* Cette information peut être distribuée sans restriction à l’intérieur comme à l’extérieur de tout organismes publics. Elle est généralement informative. Sa divulgation ne risque pas de causer des dommages ou préjudices au Ministère.

* *Privée* Cette information est strictement d’usage aux utilisateurs avec un niveau de responsabilité sur le sujet. Les utilisateurs peuvent s’en servir pour effectuer leur travail. Il pourrait y avoir des impacts indirects sur le Ministère si les informations de cette classe étaient dévoilées au public.

* *Confidentielle* L’information de cette catégorie doit être protégée par des obligations légales ou contractuelles. Elle est généralement stratégique. Elle nécessite le plus haut niveau de sécurité. Sa divulgation pourrait causer des dommages importants au Ministère.

## Obligations des intervenants clés en matière de sécurité de l’information

La présente politique fixe les obligations en matière de sécurité de l’information attribuées, notamment, au sous-ministre, au responsable organisationnel de la sécurité de l’information, aux détenteurs, aux gestionnaires d’entités administratives et aux utilisateurs.

a) Le sous-ministre : il est le premier responsable de la sécurité de l’information relevant de son autorité.

b) Le responsable organisationnel de la sécurité de l’information : il assiste le sous-ministre dans la détermination des orientations stratégiques et des priorités d’intervention.

c) Le détenteur de l’information : employé désigné par le ministère, appartenant à la classe d’emploi de niveau cadre et dont le rôle est, entre autres, de s'assurer de la sécurité de l'information et des ressources qui la sous-tendent, relevant de la responsabilité de son unité administrative.

d) Les gestionnaires : ils sont chargés de la mise en œuvre des dispositions de la présente politique auprès du personnel relevant de leur autorité.

e) Les utilisateurs : ils doivent se conformer aux directives gouvernementales, à la présente politique et aux règles qui leur sont applicables, en signant la déclaration d’engagement du MCN.

Les rôles et les responsabilités attribués à d’autres intervenants ainsi que les structures internes de coordination et de concertation en matière de sécurité de l’information sont définies dans le cadre de gestion de la sécurité de l’information, en complément à la présente politique.

## Obligation des utilisateurs

Tout utilisateur a l’obligation de protéger les actifs informationnels mis à sa disposition par le ministère. À cette fin, il doit :

a) prendre connaissance de la présente politique, des directives, des procédures et autres lignes de conduite en découlant, y adhérer et prendre l’engagement de s’y conformer, en signant la déclaration d’engagement du MCN;

b) utiliser, dans le cadre des droits d’accès qui lui sont attribués et uniquement lorsqu’ils sont nécessaires à l’exercice de ses fonctions, les actifs informationnels mis à sa disposition, en se limitant aux fins auxquelles ils sont destinés;

c) respecter les mesures de sécurité mises en place sur son poste de travail et sur tout équipement contenant des données à protéger et ne pas modifier leur configuration ou les désactiver;

d) se conformer aux exigences légales portant sur l’utilisation des produits à l’égard desquels des droits de propriété intellectuelle pourraient exister;

e) signaler immédiatement à son supérieur tout acte dont il a connaissance, susceptible de constituer une violation réelle ou présumée des règles de sécurité ainsi que toute anomalie pouvant nuire à la protection des actifs informationnels du ministère;

f) au moment de son départ du ministère, remettre les différentes cartes d’identité et d’accès, les actifs informationnels ainsi que tout l’équipement informatique ou de téléphonie mis à sa disposition dans le cadre de l'exercice de ses fonctions.

## Processus de divulgation des vulnérabilités

Le Ministère s’engage à protéger la sécurité et l’intégrité de toutes les solutions d’affaires en lien avec sa mission ainsi que les données et les renseignements que celles-ci collectent. Plusieurs services sont construits ouvertement pour permettre à tous les organismes publics (OP) de profiter d’un outil d’aide à la productivité permettant ainsi de faciliter la mise en place des solutions d’affaires en infonuagique.

*Soumettre une vulnérabilité*:

Les renseignements que vous soumettez lors du processus sont utilisés uniquement pour atténuer ou corriger les vulnérabilités.

Si vous pensez avoir trouvé une vulnérabilité en matière de sécurité, avertissez-nous dès que possible. Veuillez nous faire parvenir votre signalement par courriel au [Soutien au PGN](mailto:assistance.pgn@mcn.gouv.qc.ca).

Vous pouvez envoyer des signalements de façon anonyme. Nous ne prenons pas en charge les courriels chiffrés PGP pour le moment.

*Dans votre signalement*:

* Écrivez en anglais ou en français.

* Décrivez la vulnérabilité, l’endroit où elle a été découverte et les répercussions éventuelles de son exploitation.

* Offrez une description détaillée des étapes à suivre pour reproduire la vulnérabilité (des scénarios de démonstration de faisabilité ou des captures d’écran sont utiles). Les démonstrations de faisabilité doivent être bénignes et non destructives, afin que nous puissions trier votre signalement rapidement et de façon juste.

* Ne soumettez pas des signalements détaillant les vulnérabilités non exploitables ni des signalements indiquant que les services ne sont pas entièrement conformes aux « pratiques exemplaires », par exemple les en-têtes de sécurité manquants, ou un volume élevé de signalements de faible qualité (par exemple, à partir d’un scanneur automatisé).

* Ne communiquez pas d’autres vulnérabilités ou de renseignements connexes autres que ceux décrits dans le fichier [SECURITY.md](SECURITY.md) publié.

* N’attendez pas ou n’exigez pas de compensation financière pour les recherches et les tests vous ayant permis de révéler des vulnérabilités.

*À quoi vous attendre*:

Lorsque vous choisissez de communiquer vos coordonnées avec nous, nous nous engageons à communiquer avec vous le plus ouvertement et le plus rapidement possible.

* Nous confirmerons la réception de votre signalement dans un délai de 5 jours ouvrables.

* Au mieux de nos capacités, nous vous confirmerons l’existence de la vulnérabilité et nous serons aussi transparents que possible sur les mesures que nous prenons durant le processus de correction, notamment sur les problèmes ou les difficultés qui peuvent retarder la résolution du problème.

* Nous établirons des priorités pour la correction des vulnérabilités en examinant les conséquences, la gravité et la complexité de leur exploitation. Un certain temps peut être nécessaire pour trier ou traiter les signalements de vulnérabilité. Vous pouvez vous informer de leur statut, mais nous vous prions de ne pas le faire plus d’une fois tous les 14 jours. De cette façon, nos équipes peuvent se concentrer sur leur correction.

* Nous ferons notre possible pour maintenir un dialogue ouvert avec vous afin de discuter des problèmes et nous travaillerons avec vous pour déterminer si la faille signalée sera rendue publique et la façon de le faire, le cas échéant.

* Nous traiterons votre signalement conformément à la Loi sur l’accès à l’information et à la Loi sur la protection des renseignements personnels.

* Nous vous informerons lorsque la vulnérabilité signalée sera corrigée. Vous serez peut-être invité à confirmer que la solution corrige la vulnérabilité de manière adéquate.

## Accès et mot de passe

L’accès aux différents services partagés mis à la disposition des organismes publics est contrôlé par l’utilisation d’un compte. Toutes les ressources qui désirent avoir accès aux services partagés doivent transmettre une demande au MCN via le processus …..(À COMPLÉTER)

## Sanctions

Lorsqu’un utilisateur contrevient à la présente politique ou aux directives en découlant, il s’expose à des mesures disciplinaires, administratives ou légales, en fonction de la gravité de son geste. Ces mesures peuvent inclure la suspension des privilèges, la réprimande, la suspension, le congédiement ou autre, et ce, conformément aux dispositions des conventions collectives, des ententes ou des contrats. L’organisme public peut transmettre à toute autorité judiciaire les renseignements colligés et qui le portent à croire qu’une infraction à toute loi ou règlement en vigueur a été commise.

## Examen

La présente politique sera bonifiée au rythme de l’évolution des services offerts par le Ministère auprès des organismes publics. L’utilisateur doit donc s’y référer régulièrement puisque cette politique sera réexaminée au besoin.
