<p align="left">
  <a href="https://aeron7.github.io/nsepython/" target="_blank">
    <img width="300" src="https://raw.githubusercontent.com/aeron7/nsepython/master/nsepython.png" alt="logo">
  </a>
</p>

#### NSEPython is a Python library to get publicly available data on the current [NSEIndia](https://nseindia.com) and [NIFTY Indices](https://www.niftyindices.com/) site by communicating with their REST APIs.

<p align="left">
  <a href="https://unofficed.com/nse-python/documentation/" target="_blank">
    <img width="200" src="https://raw.githubusercontent.com/aeron7/nsepython/master/button_read-the-documentation.png" alt="logo">
  </a>
</p>

## Support and Beta Functions

- If you have other doubts or want to check out the beta functions, visit the [NSEPython Discussions](https://forum.unofficed.com/c/programming/nse-python-api/) forum.
- If you have feature requests, you can submit them at the [NSEPython Feature Request](https://forum.unofficed.com/t/nsepython-discussion-and-feature-request/665) forum.

## Versions

There are two versions of NSEPython depending on the execution environment. While it's technically feasible to combine these versions into a single program, doing so could introduce latency. Given the financial nature of this program, time is of the essence.


| NSEPython Edition          | Compatibility                | Tested Environments           |
|---------------------------|-----------------------------|-------------------------------|
| [Local Edition](https://github.com/aeron7/nsepython)    | Laptops (Windows 9, 10)     | Windows 9, Windows 10         |
| [Server Edition](https://github.com/aeron7/nsepythonserver)   | Servers (AWS, Google Colab, DigitalOcean) | AWS, Google Colab, DigitalOcean |

## Installation

Use the package manager [pip](https://pypi.org/project/nsepython/) to install nsepython.

#### [NSEPython Local Edition](https://github.com/aeron7/nsepython)

Access NSEPython for laptops, specifically tailored for Windows 9 and Windows 10 compatibility.


```bash
pip install nsepython
```

#### [NSEPython Server Edition](https://github.com/aeron7/nsepythonserver)

Leverage NSEPython designed for server environments, seamlessly functioning on AWS, Google Colab, and DigitalOcean.

```bash
pip install nsepythonserver
```

## Cross Library Migration
All the functions from the two renowned packages, NsepY and NSETools, have been migrated here with the same function names. Both of these packages had been left unmaintained for a considerable period.

## Advanced Usecases

### Mastering AlgoTrading: A Beginner's Guide using NSEPython
- [Candlestick Charts in Python with NSEPython and Plotly](https://unofficed.com/courses/mastering-algotrading-beginners-guide-nsepython/lessons/candlestick-charts-python/)
- [Calculate any Option Greek using Black Scholes Formula in Python](https://unofficed.com/black-scholes-formula-in-python/)
- [How to find the beta of Indian stocks using Python?](https://unofficed.com/how-to-find-the-beta-of-indian-stocks-using-python/)
- [How to get Historical PE, PB and Dividend Ratio of any index using Python](https://unofficed.com/nse-python/documentation/nsepy/#index_pe_pb_div)

### Designing an Index Fund From Scratch in Indian Share Market
- [Building An Market-Weight Adjusted N50 Index Fund – Part I](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/building-an-market-weight-adjusted-n50-index-fund-i/)
- [Building An Market-Weight Adjusted N50 Index Fund – Part II](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/building-an-market-weight-adjusted-n50-index-fund-part-ii/)
- [How to calculate NIFTY 50 value from the stock prices in Python](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/how-to-calculate-nifty-50-value-from-the-stock-prices-in-python/)

### Coding Heatmap and ORB
- [Creating Dynamic Heatmap for Indian Stock Market](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/creating-dynamic-heatmap-for-indian-stock-market/)
- [Coding Heatmap Opening Range Breakout Strategy in Python – Part 1](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/opening-range-breakout-python-part-i/)
- [Coding Heatmap Opening Range Breakout Strategy in Python – Part 2](https://unofficed.com/courses/designing-an-index-fund-from-scratch-in-indian-share-market/lessons/opening-range-breakout-python-part-ii/)

### Markov Chain

- [Stochastic Modeling in Stock Market](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/stochastic-modeling-in-stock-market/)
- [Application of Markov Chains in Stock Market](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/application-of-markov-chains-in-stock-market/)
- [Markov Chains in Stock Market Using Python – Getting Transition Matrix​](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/markov-chains-in-stock-market-using-python-getting-transition-matrix/)
- [How to do Random Walk using NSEPython in Indian Stock Market](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/how-to-do-random-walk-using-nsepython-in-indian-stock-market/)
- [Markov Chain and Linear Algebra – Calculation of Stationary Distribution using Python​](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/markov-chain-and-linear-algebra-calculation-of-stationary-distribution-using-python/)
- [Find the Equilibrium Matrix in Markov Chain using Python in Indian Stock Market](https://unofficed.com/courses/markov-model-application-of-markov-chain-in-stock-market/lessons/find-the-equilibrium-matrix-in-markov-chain-using-python-in-stock-market/)


## Leverage

In [Leverage](https://www.unofficed.com/leverage/), a plethora of trader-focused tools has been meticulously crafted using NSEPython.

Here's an illustration of a [Sectoral Heatmap](https://unofficed.com/leverage/sectoral-heatmap/), showcasing the extent of complexity that NSEPython API can effortlessly handle.

<p align="left">
  <a href="https://www.unofficed.com/leverage/" target="_blank">
    <img  src="https://unofficed.com/wp-content/uploads/2023/08/Sectoral-Heatmap.png" alt="logo">
  </a>
</p>




